package org.jeecg.modules.checkData.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 * 检查数据-设备检查记录数据-钢轨伤损情况检查表
 * </p>
 *
 * @author hkl
 * @since 2023-07-09
 */
@Data
@ApiModel(value = "RailWearRecord对象", description = "检查数据-设备检查记录数据-钢轨伤损情况检查表")
public class RailWearRecordDTO {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("检查编号")
    private String ekCode;

    @ApiModelProperty("开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startTime;

    @ApiModelProperty("结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endTime;


}
