package org.jeecg.modules.checkData.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 线路巡查记录主表-巡道员使用
 * </p>
 *
 * @author hkl
 * @since 2023-07-08
 */
@Data
public class RecordPatrolMasterDTO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date updateTime;

    @ApiModelProperty("检查批次编号")
    private String ekCode;

    @ApiModelProperty("工单编号")
    private String workCode;

    @ApiModelProperty("检查日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date inspectTime;

    @ApiModelProperty("天气")
    private String weather;

    @ApiModelProperty("巡查线路id")
    private String lightRailId;

    @ApiModelProperty("巡查线路名称")
    private String lightRailName;

    @ApiModelProperty("计划巡道里程（km）")
    private BigDecimal plannedPatrolMileage;

    @ApiModelProperty("巡道线别id")
    private String lineAliasId;

    @ApiModelProperty("巡道线别名称")
    private String lineAliasName;

    @ApiModelProperty("起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty("终点里程")
    private BigDecimal endMileage;

    @ApiModelProperty("完成里程")
    private BigDecimal completedMileage;

    @ApiModelProperty("巡道类型翻译(1:步行巡道 2:乘车巡道)")
    private String patrolType;

    @ApiModelProperty("巡道工时")
    private BigDecimal patrolHourse;

    @ApiModelProperty("检查人姓名")
    private String checkBy;

    @ApiModelProperty("清点时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd hh:mm")
    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm")
    private Date checkTime;

    @ApiModelProperty("销点时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd hh:mm")
    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm")
    private Date pinpointTime;

    @ApiModelProperty("审核人姓名")
    private String verifyBy;

    @ApiModelProperty("审核时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date verifyTime;

    @ApiModelProperty("巡道员备忘录")
    private String remark;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    private String delFlag;


}
