package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 检查数据设备-设备检查记录数据-曲线磨耗情况检查
 * </p>
 *
 * @author hkl
 * @since 2023-07-09
 */
@Data
@TableName("t_ek_curve_wear_record")
@ApiModel(value = "CurveWearRecord对象", description = "检查数据设备-设备检查记录数据-曲线磨耗情况检查")
public class CurveWearRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("设备检查记录主表id")
    @TableField("records_master_check_id")
    private String recordsMasterCheckId;

    @ApiModelProperty("曲线设备id")
    @TableField("curve_id")
    private String curveId;

    @ApiModelProperty("曲线单元编码")
    @TableField("curve_code")
    private String curveCode;

    @ApiModelProperty("检查设备类型（1-钢轨,2-曲线,3-竖曲线,4-道岔）")
    @TableField("project_type")
    private Integer projectType;

    @ApiModelProperty("曲线半径")
    @TableField("curve_radius")
    private BigDecimal curveRadius;

    @ApiModelProperty("曲线超高")
    @TableField("curve_super_high")
    private BigDecimal curveSuperHigh;

    @ApiModelProperty("圆曲线长")
    @TableField("curve_tangent_len")
    private BigDecimal curveTangentLen;

    @ApiModelProperty("缓和曲线长")
    @TableField("transition_curve_high")
    private BigDecimal transitionCurveHigh;

    @ApiModelProperty("圆曲转向（1：左 2：右）")
    @TableField("curve_turn")
    private String curveTurn;

    @ApiModelProperty("检查类型（1：垂直磨耗 2：侧面磨耗）")
    @TableField("curve_type")
    private Integer curveType;

    @ApiModelProperty("2H")
    @TableField("two_num")
    private BigDecimal twoNum;

    @ApiModelProperty("HY")
    @TableField("hy_num")
    private BigDecimal hyNum;

    @ApiModelProperty("HZ")
    @TableField("hz_num")
    private BigDecimal hzNum;

    @ApiModelProperty("QZ")
    @TableField("qz_num")
    private BigDecimal qzNum;

    @ApiModelProperty("YH")
    @TableField("yh_num")
    private BigDecimal yhNum;

    @ApiModelProperty("超限记录类型(1:无，2：轻伤，3：重伤)")
    @TableField("over_type")
    private Integer overType;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    @TableField("del_flag")
    private String delFlag;

}
