package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 动静态几何尺寸对应的添乘仪详情表
 * </p>
 *
 * @author hkl
 * @since 2023-08-31
 */
@Getter
@Setter
@TableName("t_djt_movement_additive_info_unit_device_map")
@ApiModel(value = "MovementAdditiveInfoUnitDeviceMap对象", description = "动静态几何尺寸对应的添乘仪详情表")
public class MovementAdditiveInfoUnitDeviceMap implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    @TableField("movement_master_id")
    private String movementMasterId;

    @ApiModelProperty("设备单元id")
    @TableField("unit_id")
    private String unitId;

    @ApiModelProperty("设备单元编码")
    @TableField("unit_code")
    private String unitCode;

    @ApiModelProperty("设备单元编码")
    @TableField("unit_device_code")
    private String unitDeviceCode;

    @ApiModelProperty("设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔")
    @TableField("unit_type")
    private Integer unitType;

    @ApiModelProperty("设备单元类型名称")
    @TableField("unit_type_name")
    private String unitTypeName;

    @ApiModelProperty("设备单元起始里程")
    @TableField("unit_start_mileage")
    private BigDecimal unitStartMileage;

    @ApiModelProperty("设备单元中心里程")
    @TableField("unit_center_mileage")
    private BigDecimal unitCenterMileage;

    @ApiModelProperty("设备单元终点里程")
    @TableField("unit_end_mileage")
    private BigDecimal unitEndMileage;

    @ApiModelProperty("测点里程")
    @TableField("point_mileage")
    private BigDecimal pointMileage;

    @ApiModelProperty("水平加速度")
    @TableField("zontal_speed")
    private BigDecimal zontalSpeed;

    @ApiModelProperty("水平加速度等级")
    @TableField("zontal_speed_level")
    private Integer zontalSpeedLevel;

    @ApiModelProperty("垂直加速度")
    @TableField("vertical_speed")
    private BigDecimal verticalSpeed;

    @ApiModelProperty("垂直加速度等级")
    @TableField("vertical_speed_level")
    private Integer verticalSpeedLevel;

    @ApiModelProperty("速度")
    @TableField("speed")
    private BigDecimal speed;

    @ApiModelProperty("手动标记")
    @TableField("mark")
    private String mark;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    @TableField("del_flag")
    private String delFlag;

    @ApiModelProperty("排序字段")
    @TableField("info_sort")
    private Integer infoSort;

}
