package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 动静态几何尺寸对应得里程相关信息表	
 * </p>
 *
 * @author hkl
 * @since 2023-07-11
 */
@Getter
@Setter
@TableName("t_djt_movement_course")
@ApiModel(value = "MovementCourse对象", description = "动静态几何尺寸对应得里程相关信息表	")
public class MovementCourse implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    @TableField("movement_master_id")
    private String movementMasterId;

    @ApiModelProperty("检查起始里程（m）")
    @TableField("course_starting_mileage")
    private BigDecimal courseStartingMileage;

    @ApiModelProperty("检查终点里程(m)")
    @TableField("course_end_mileage")
    private BigDecimal courseEndMileage;

    @ApiModelProperty("曲线半径（m）")
    @TableField("curve_radius")
    private BigDecimal curveRadius;

    @ApiModelProperty("超高（mm）")
    @TableField("super_high")
    private BigDecimal superHigh;

    @ApiModelProperty("加宽（mm）")
    @TableField("widen")
    private BigDecimal widen;

    @ApiModelProperty("顺坡率（‰）")
    @TableField("slope_ratio")
    private BigDecimal slopeRatio;

    @ApiModelProperty("长度（m）")
    @TableField("long_extent")
    private BigDecimal longExtent;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    @TableField("del_flag")
    private String delFlag;

    @ApiModelProperty("排序")
    @TableField("sort")
    private Integer sort;

}
