package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 轨检车-》TQI总结报告	
 * </p>
 *
 * @author hkl
 * @since 2023-07-27
 */
@Getter
@Setter
@TableName("t_djt_movement_tqi_report")
@ApiModel(value = "MovementTqiReport对象", description = "轨检车-》TQI总结报告	")
public class MovementTqiReport implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    @TableField("movement_master_id")
    private String movementMasterId;

    @ApiModelProperty("开始里程(m)")
    @TableField("start_mileage")
    private BigDecimal startMileage;

    @ApiModelProperty("终点里程(m)")
    @TableField("end_mileage")
    private BigDecimal endMileage;

    @ApiModelProperty("区间名称")
    @TableField("section_name")
    private String sectionName;

    @ApiModelProperty("高低左")
    @TableField("high_low_left")
    private String highLowLeft;

    @ApiModelProperty("高低右")
    @TableField("high_low_right")
    private String highLowRight;

    @ApiModelProperty("轨向左")
    @TableField("track_left")
    private String trackLeft;

    @ApiModelProperty("轨向右")
    @TableField("track_right")
    private String trackRight;

    @ApiModelProperty("水平（mm）")
    @TableField("level")
    private String level;

    @ApiModelProperty("轨距（mm）")
    @TableField("track_gauge")
    private String trackGauge;

    @ApiModelProperty("三角坑（mm）")
    @TableField("triangular_pit")
    private String triangularPit;

    @ApiModelProperty("TQI数值")
    @TableField("tqi_come_upon")
    private String tqiComeUpon;

    @ApiModelProperty("TQI超标")
    @TableField("tqi_above_standard")
    private String tqiAboveStandard;

    @ApiModelProperty("扣分")
    @TableField("deduct")
    private String deduct;

    @ApiModelProperty("检测标准")
    @TableField("standard")
    private String standard;

    @ApiModelProperty("速度（km/h）")
    @TableField("spend")
    private String spend;

    @ApiModelProperty("是否删除（0：未删除； 1：已删除）")
    @TableField("del_flag")
    private String delFlag;

    @ApiModelProperty("导入顺序")
    @TableField("sort")
    private Integer sort;


}
