package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 检查数据-设备检查记录数据-钢轨伤损情况检查表
 * </p>
 *
 * @author hkl
 * @since 2023-07-09
 */
@Getter
@Setter
@TableName("t_ek_rail_wear_record")
@ApiModel(value = "RailWearRecord对象", description = "检查数据-设备检查记录数据-钢轨伤损情况检查表")
public class RailWearRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("设备检查记录主表id")
    @TableField("records_master_check_id")
    private String recordsMasterCheckId;

    @ApiModelProperty("线别Id")
    @TableField("line_alias_id")
    private String lineAliasId;

    @ApiModelProperty("线别名称")
    @TableField("line_alias_name")
    private String lineAliasName;

    @ApiModelProperty("检查设备id")
    @TableField("device_project_id")
    private String deviceProjectId;

    @ApiModelProperty("检查设备单元code")
    @TableField("device_project_code")
    private String deviceProjectCode;

    @ApiModelProperty("检查设备类型（1-钢轨,2-曲线,3-竖曲线,4-道岔）")
    @TableField("device_project_type")
    private Integer deviceProjectType;

    @ApiModelProperty("股别(1-左股，2-右股)")
    @TableField("damage_level")
    private Integer damageLevel;

    @ApiModelProperty("伤损钢轨数量")
    @TableField("damage_num")
    private Integer damageNum;


    @ApiModelProperty("伤损里程")
    @TableField("damage_mileage")
    private BigDecimal damageMileage;

    @ApiModelProperty("伤损种类（1-鱼鳞纹,2-剥落掉块,3-表面疲劳裂纹,4-轨底掉块,5-灼伤,6-核伤,7-焊缝,8-其他）")
    @TableField("damage_type")
    private Integer damageType;

    @ApiModelProperty("伤损程度(1-轻伤,2-轻伤有发展,3-重伤)")
    @TableField("damage_degree")
    private Integer damageDegree;

    @ApiModelProperty("换轨计划")
    @TableField("damage_plan")
    private String damagePlan;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    @TableField("del_flag")
    private String delFlag;



    //***********************作废字段****************************************
    @ApiModelProperty("左股仪器编码-作废")
    @TableField("left_femoral_apparatus_code")
    private String leftFemoralApparatusCode;

    @ApiModelProperty("左股仪器-作废")
    @TableField("left_femoral_apparatus")
    private String leftFemoralApparatus;

    @ApiModelProperty("左股轨向-作废")
    @TableField("left_track_direction")
    private String leftTrackDirection;

    @ApiModelProperty("右股仪器编码-作废")
    @TableField("right_femoral_apparatus_code")
    private String rightFemoralApparatusCode;

    @ApiModelProperty("右股仪器-作废")
    @TableField("right_femoral_apparatus")
    private String rightFemoralApparatus;

    @ApiModelProperty("右股轨向-作废")
    @TableField("right_track_direction")
    private String rightTrackDirection;

    @ApiModelProperty("钢轨轨型-作废")
    @TableField("rail_type")
    private String railType;
}
