package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 线路巡查记录-协助情况表-巡道员使用
 * </p>
 *
 * @author hkl
 * @since 2023-07-08
 */
@Getter
@Setter
@TableName("t_xd_record_patrol__master_assist")
@ApiModel(value = "RecordPatrolMasterAssist对象", description = "线路巡查记录-协助情况表-巡道员使用")
public class RecordPatrolMasterAssist implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date updateTime;

    @ApiModelProperty("线路巡查记录主表id-外键")
    @TableField("record_master_id")
    private String recordMasterId;

    @ApiModelProperty("巡查区间id")
    @TableField("subway_section_id")
    private String subwaySectionId;

    @ApiModelProperty("巡查区间名称")
    @TableField("subway_section_name")
    private String subwaySectionName;

    @ApiModelProperty("线别id")
    @TableField("line_alias_id")
    private String lineAliasId;

    @ApiModelProperty("线别名称")
    @TableField("line_alias_name")
    private String lineAliasName;

    @ApiModelProperty("起始里程")
    @TableField("starting_mileage")
    private BigDecimal startingMileage;

    @ApiModelProperty("终点里程")
    @TableField("end_mileage")
    private BigDecimal endMileage;

    @ApiModelProperty("问题记录")
    @TableField("problem_record")
    private String problemRecord;

    @ApiModelProperty("处理情况")
    @TableField("handing_log")
    private String handingLog;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    @TableField("del_flag")
    private String delFlag;


}
