package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 线路巡查记录详情表-巡道员使用
 * </p>
 *
 * @author hkl
 * @since 2023-07-08
 */
@Getter
@Setter
@TableName("t_xd_record_patrol_master_info")
@ApiModel(value = "RecordPatrolMasterInfo对象", description = "线路巡查记录详情表-巡道员使用")
public class RecordPatrolMasterInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date updateTime;

    @ApiModelProperty("线路巡查记录主表id-外键")
    @TableField("record_master_id")
    private String recordMasterId;

    @ApiModelProperty("检查项目名称")
    @TableField("ek_project_name")
    private String ekProjectName;

    @ApiModelProperty("重点检查项目内容")
    @TableField("ek_project_content")
    private String ekProjectContent;

    @ApiModelProperty("问题记录")
    @TableField("problem_record")
    private String problemRecord;

    @ApiModelProperty("处理情况")
    @TableField("handing_log")
    private String handingLog;

    @ApiModelProperty("是否满足（1：是；2：否）")
    @TableField("status")
    private String status;

    @ApiModelProperty("排序")
    @TableField("seq")
    private Integer seq;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    @TableField("del_flag")
    private String delFlag;


}
