package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.jeecg.modules.utils.ExcelExport;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 设备检查记录主表
 * </p>
 *
 * @author hkl
 * @since 2023-07-07
 */
@Getter
@Setter
@TableName("t_ek_records_master_check")
@ApiModel(value = "RecordsMasterCheck对象", description = "设备检查记录主表")
public class RecordsMasterCheck implements Serializable {

    private static final long serialVersionUID = 1L;

    @ExcelExport(value = "序号", sort = 1)
    @TableField(exist = false)
    private int rowNum;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("设备检查类型（1：道岔使用情况；2：钢轨伤损情况；3：曲线磨损情况；4：钢轨波磨情况；5：道床使用情况）")
    @TableField("type")
    private String type;

    @ExcelExport(value = "检查d批次编号", sort = 2)
    @ApiModelProperty("检查批次编号")
    @TableField("ek_code")
    private String ekCode;

    @ExcelExport(value = "工单编号", sort = 3)
    @ApiModelProperty("工单编号")
    @TableField("work_code")
    private String workCode;

    @ApiModelProperty("轨距水平尺编号")
    @TableField("gauge_code")
    private String gaugeCode;

    @ApiModelProperty("检查区间id")
    @TableField("subway_section_id")
    private String subwaySectionId;

    @ApiModelProperty("检查区间名称")
    @TableField("subway_section_name")
    @ExcelExport(value = "检查区间名称", sort = 4)
    private String subwaySectionName;

    @ApiModelProperty("所属线路id")
    @TableField("light_rail_id")
    private String lightRailId;

    @ApiModelProperty("所属线路名称")
    @TableField("light_rail_name")
    @ExcelExport(value = "所属线路", sort = 5)
    private String lightRailName;

    @ApiModelProperty("所属线别id")
    @TableField("line_alias_id")
    private String lineAliasId;

    @ApiModelProperty("所属线别名称")
    @TableField("line_alias_name")
    @ExcelExport(value = "所属线别", sort = 6)
    private String lineAliasName;

    @ApiModelProperty("起始里程")
    @TableField("starting_mileage")
    @ExcelExport(value = "起始里程", sort = 7)
    private BigDecimal startingMileage;

    @ApiModelProperty("终点里程")
    @TableField("end_mileage")
    @ExcelExport(value = "终点里程", sort = 8)
    private BigDecimal endMileage;

    @ApiModelProperty("共通字段1(根据字段type来赋值)->(线路方向)")
    @TableField("num_one")
    private String numOne;

    @ApiModelProperty("共通字段2(根据字段type来赋值)->（推行方向）")
    @TableField("num_two")
    private String numTwo;

    @ApiModelProperty("共通字段3(根据字段type来赋值)->(检查时间)")
    @TableField("num_three")
    private String numThree;

    @ApiModelProperty("备注")
    @TableField("remark")
    @ExcelExport(value = "备注", sort = 13)
    private String remark;

    @ApiModelProperty("检查人姓名")
    @TableField("check_by")
    @ExcelExport(value = "检查人姓名", sort = 9)
    private String checkBy;

    @ApiModelProperty("检查日期")
    @TableField("check_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ExcelExport(value = "检查日期", format = "yyyy-MM-dd", sort = 10)
    private Date checkTime;

    @ApiModelProperty("审核人姓名")
    @TableField("verify_by")
    @ExcelExport(value = "审核人姓名", sort = 11)
    private String verifyBy;

    @ApiModelProperty("审核时间")
    @TableField("verify_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ExcelExport(value = "审核日期", format = "yyyy-MM-dd", sort = 12)
    private Date verifyTime;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    @TableField("del_flag")
    private String delFlag;


}
