package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 设备检查记录数据-钢轨波磨情况检查数据-波长
 * </p>
 *
 * @author hkl
 * @since 2023-08-04
 */
@Getter
@Setter
@TableName("t_ek_records_master_corr_wave")
@ApiModel(value = "RecordsMasterCorrWave对象", description = "设备检查记录数据-钢轨波磨情况检查数据-波长")
public class RecordsMasterCorrWave implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("设备检查记录主表id")
    @TableField("records_master_id")
    private String recordsMasterId;

    @ApiModelProperty("类型（1：RMS；2：AP2P；3：FIL）")
    @TableField("type")
    private String type;

    @ApiModelProperty("波长")
    @TableField("wave")
    private String wave;

    @ApiModelProperty("值1")
    @TableField("num_one")
    private BigDecimal numOne;

    @ApiModelProperty("值2")
    @TableField("num_two")
    private BigDecimal numTwo;

    @ApiModelProperty("值3")
    @TableField("num_three")
    private BigDecimal numThree;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    @TableField("del_flag")
    private String delFlag;

    @ApiModelProperty("导入顺序")
    @TableField("sort")
    private Integer sort;

}
