package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 设备检查记录数据-道床使用情况记录数据
 * </p>
 *
 * @author hkl
 * @since 2023-07-07
 */
@Getter
@Setter
@TableName("t_ek_track_bed_management_check")
@ApiModel(value = "TrackBedManagementCheck对象", description = "设备检查记录数据-道床使用情况记录数据")
public class TrackBedManagementCheck implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date updateTime;

    @ApiModelProperty("设备检查记录主表id->外键")
    @TableField("records_master_check_id")
    private String recordsMasterCheckId;

    @ApiModelProperty("道床id->外键")
    @TableField("trak_bed_management_id")
    private String trakBedManagementId;

    @ApiModelProperty("检查项目名称")
    @TableField("ek_project_name")
    private String ekProjectName;

    @ApiModelProperty("检查项目内容")
    @TableField("ek_project_content")
    private String ekProjectContent;

    @ApiModelProperty("检查合格评判标准")
    @TableField("ek_project_template")
    private String ekProjectTemplate;

    @ApiModelProperty("现场检查项目状态翻译")
    @TableField("ek_project_status_str")
    private String ekProjectStatusStr;

    @ApiModelProperty("现场检查项目状态（1：合格；2：良好；3：不合格）")
    @TableField("ek_project_status")
    private String ekProjectStatus;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    @TableField("del_flag")
    private String delFlag;


}
