package org.jeecg.modules.checkData.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.modules.checkData.dto.CurveWearRecordDTO;
import org.jeecg.modules.checkData.entity.CurveWearRecord;
import org.jeecg.modules.checkData.mapper.CurveWearRecordMapper;
import org.jeecg.modules.checkData.service.ICurveWearRecordService;
import org.jeecg.modules.checkData.vo.CurveWearRecordDetailVO;
import org.jeecg.modules.checkData.vo.CurveWearRecordVO;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 检查数据设备-设备检查记录数据-曲线磨耗情况检查 服务实现类
 * </p>
 *
 * @author hkl
 * @since 2023-07-09
 */
@Service
public class CurveWearRecordServiceImpl extends ServiceImpl<CurveWearRecordMapper, CurveWearRecord> implements ICurveWearRecordService {

    @Override
    public Page<CurveWearRecordVO> queryPageList(Page<CurveWearRecordVO> pageData, CurveWearRecordDTO dto) {
        return this.baseMapper.queryPageList(pageData,dto);
    }

    @Override
    public List<CurveWearRecordDetailVO> getDetail(String masterRecordId) {
        return this.baseMapper.getDetail(masterRecordId);
    }
}
