package org.jeecg.modules.checkData.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.jeecg.modules.checkData.dto.MovementAdditiveInfoDTO;
import org.jeecg.modules.checkData.dto.MovementRecordsMasterDTO;
import org.jeecg.modules.checkData.entity.MovementRecordsMaster;
import org.jeecg.modules.checkData.mapper.MovementRecordsMasterMapper;
import org.jeecg.modules.checkData.service.IMovementRecordsMasterService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.modules.checkData.vo.MovementAdditiveInfoVO;
import org.jeecg.modules.checkData.vo.MovementRecordsMasterVO;
import org.jeecg.modules.homePage.vo.ToDoDetailVO;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 动静态几何尺寸数据主表	 服务实现类
 * </p>
 *
 * @author hkl
 * @since 2023-07-11
 */
@Service
public class MovementRecordsMasterServiceImpl extends ServiceImpl<MovementRecordsMasterMapper, MovementRecordsMaster> implements IMovementRecordsMasterService {
    /**
     * 动静态几何尺寸列表-分页列表查询
     *
     * @param pageData
     * @param dto
     * @return
     */
    @Override
    public Page<MovementRecordsMasterVO> queryPageList(Page<MovementRecordsMasterVO> pageData, MovementRecordsMasterDTO dto) {
        return this.baseMapper.queryPageList(pageData, dto);
    }

    /**
     * 查询添乘仪详情
     *
     * @param pageData
     * @param dto
     * @return
     */
    @Override
    public Page<MovementAdditiveInfoVO> queryPageAdditiveInfoList(Page<MovementAdditiveInfoVO> pageData, MovementAdditiveInfoDTO dto) {
        return this.baseMapper.queryPageAdditiveInfoList(pageData, dto);
    }

    @Override
    public List<ToDoDetailVO> getTodoList(String currentUserId) {
        return this.baseMapper.getTodoList(currentUserId);
    }
}
