package org.jeecg.modules.checkData.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 检查数据-设备检查记录数据-钢轨波磨设备检查记录表
 * </p>
 *
 * @author hkl
 * @since 2024-07-11
 */
@Getter
@Setter
@ApiModel(value = "CorrugationRecord对象", description = "检查数据-设备检查记录数据-钢轨波磨设备检查记录表	")
public class CorrugationRecordVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("设备检查记录主表id")
    private String recordsMasterCheckId;

    @ApiModelProperty("检查批次号")
    private String ekCode;

    @ApiModelProperty("工单编号")
    private String workCode;

    @ApiModelProperty("检查区间id")
    private String subwaySectionId;

    @ApiModelProperty("检查区间名称")
    private String subwaySectionName;

    @ApiModelProperty("所属线路id")
    private String lightRailId;

    @ApiModelProperty("所属线路名称")
    private String lightRailName;

    @ApiModelProperty("所属线别id")
    private String lineAliasId;

    @ApiModelProperty("所属线别名称")
    private String lineAliasName;

    @ApiModelProperty("车站id")
    private String stationId;

    @ApiModelProperty("车站名称")
    private String stationName;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("检查日期")
    private Date checkTime;

    @ApiModelProperty("检查人")
    private String checkBy;

    @ApiModelProperty("审核人姓名")
    private String verifyBy;

    @ApiModelProperty("审核时间")
    private Date verifyTime;

    @ApiModelProperty("起点里程")
    private BigDecimal startingMileage;

    @ApiModelProperty("终点里程")
    private BigDecimal endMileage;

    @ApiModelProperty("备注")
    private String remark;


}
