package org.jeecg.modules.checkData.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 检查数据设备-设备检查记录数据-曲线磨耗情况检查
 * </p>
 *
 * @author hkl
 * @since 2023-07-09
 */
@Data
@ApiModel(value = "CurveWearRecordDetailVO对象", description = "CurveWearRecordDetailVO对象")
public class CurveWearRecordDetailVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("设备检查记录主表id")
    private String recordsMasterCheckId;

    @ApiModelProperty("曲线设备id")
    private String curveId;

    @ApiModelProperty("曲线单元编码")
    private String curveCode;

    @ApiModelProperty("检查设备类型（1-钢轨,2-曲线,3-竖曲线,4-道岔）")
    private Integer projectType;

    @ApiModelProperty("检查类型（1：垂直磨耗 2：侧面磨耗）")
    private Integer curveType;

    @ApiModelProperty("2H")
    private BigDecimal twoNum;

    @ApiModelProperty("HY")
    private BigDecimal hyNum;

    @ApiModelProperty("HZ")
    private BigDecimal hzNum;

    @ApiModelProperty("QZ")
    private BigDecimal qzNum;

    @ApiModelProperty("YH")
    private BigDecimal yhNum;

    @ApiModelProperty("超限记录类型(1:无，2：轻伤，3：重伤)")
    private Integer overType;

    @ApiModelProperty("曲线半径")
    private BigDecimal curveRadius;

    @ApiModelProperty("曲线超高")
    private BigDecimal curveSuperHigh;

    @ApiModelProperty("圆曲线长")
    private BigDecimal curveTangentLen;

    @ApiModelProperty("缓和曲线长")
    private BigDecimal transitionCurveHigh;

    @ApiModelProperty("圆曲转向（1：左 2：右）")
    private String curveTurn;

}
