package org.jeecg.modules.checkData.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 动静态几何尺寸对应得里程相关信息表
 * </p>
 *
 * @author hkl
 * @since 2023-07-11
 */
@Data
public class MovementCourseVO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    private String movementMasterId;

    @ApiModelProperty("检查起始里程（m）")
    private BigDecimal courseStartingMileage;

    @ApiModelProperty("检查终点里程(m)")
    private BigDecimal courseEndMileage;

    @ApiModelProperty("曲线半径（m）")
    private BigDecimal curveRadius;

    @ApiModelProperty("超高（mm）")
    private BigDecimal superHigh;

    @ApiModelProperty("加宽（mm）")
    private BigDecimal widen;

    @ApiModelProperty("顺坡率（‰）")
    private BigDecimal slopeRatio;

    @ApiModelProperty("长度（m）")
    private BigDecimal longExtent;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    private String delFlag;

    @ApiModelProperty("排序")
    private Integer sort;
}
