package org.jeecg.modules.checkData.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 轨检车-》超限记录报告
 * </p>
 *
 * @author hkl
 * @since 2023-07-27
 */
@Data
public class MovementOverReportVO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    private String movementMasterId;

    @ApiModelProperty("序号")
    private String xuhao;

    @ApiModelProperty("里程(m)")
    private BigDecimal mileage;

    @ApiModelProperty("区间名称")
    private String sectionName;

    @ApiModelProperty("超限类型")
    private String overrunType;

    @ApiModelProperty("超限等级")
    private String overrunLevel;

    @ApiModelProperty("长度")
    private String longitude;

    @ApiModelProperty("峰值（mm或g）")
    private String peakValue;

    @ApiModelProperty("管理数据差")
    private String dataDifference;

    @ApiModelProperty("线性")
    private String xianxing;

    @ApiModelProperty("检测标准")
    private String standard;

    @ApiModelProperty("速度（km/h）")
    private String spend;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("是否删除（0：未删除； 1：已删除）")
    private String delFlag;

    @ApiModelProperty("导入顺序")
    private Integer sort;


}
