package org.jeecg.modules.checkData.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 * 轨检车-》公里总结报告表
 * </p>
 *
 * @author hkl
 * @since 2023-07-27
 */
@Data
public class MovementSummaryReportVO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    private String movementMasterId;

    @ApiModelProperty("公里")
    private String kilometer;

    @ApiModelProperty("长度(m)")
    private String longitude;

    @ApiModelProperty("左高低1")
    private String leftHighLowOne;

    @ApiModelProperty("左高低2")
    private String leftHighLowTwo;

    @ApiModelProperty("左高低3")
    private String leftHighLowThree;

    @ApiModelProperty("左高低4")
    private String leftHighLowFour;

    @ApiModelProperty("右高低1")
    private String rightHighLowOne;

    @ApiModelProperty("右高低2")
    private String rightHighLowTwo;

    @ApiModelProperty("右高低3")
    private String rightHighLowThree;

    @ApiModelProperty("右高低4")
    private String rightHighLowFour;

    @ApiModelProperty("左轨向1")
    private String leftTrackOne;

    @ApiModelProperty("左轨向2")
    private String leftTrackTwo;

    @ApiModelProperty("左轨向3")
    private String leftTrackThree;

    @ApiModelProperty("左轨向4")
    private String leftTrackFour;

    @ApiModelProperty("右轨向1")
    private String rightTrackOne;

    @ApiModelProperty("右轨向2")
    private String rightTrackTwo;

    @ApiModelProperty("右轨向3")
    private String rightTrackThree;

    @ApiModelProperty("右轨向4")
    private String rightTrackFour;

    @ApiModelProperty("轨距1")
    private String trackGaugeOne;

    @ApiModelProperty("轨距2")
    private String trackGaugeTwo;

    @ApiModelProperty("轨距3")
    private String trackGaugeThree;

    @ApiModelProperty("轨距4")
    private String trackGaugeFour;

    @ApiModelProperty("水平1")
    private String levelOne;

    @ApiModelProperty("水平2")
    private String levelTwo;

    @ApiModelProperty("水平3")
    private String levelThree;

    @ApiModelProperty("水平4")
    private String levelFour;

    @ApiModelProperty("三角坑1")
    private String triangularPitOne;

    @ApiModelProperty("三角坑2")
    private String triangularPitTwo;

    @ApiModelProperty("三角坑3")
    private String triangularPitThree;

    @ApiModelProperty("三角坑4")
    private String triangularPitFour;

    @ApiModelProperty("曲率1")
    private String curvatureOne;

    @ApiModelProperty("曲率2")
    private String curvatureTwo;

    @ApiModelProperty("曲率3")
    private String curvatureThree;

    @ApiModelProperty("曲率4")
    private String curvatureFour;

    @ApiModelProperty("垂向加速度1")
    private String droopVelocityOne;

    @ApiModelProperty("垂向加速度2")
    private String droopVelocityTwo;

    @ApiModelProperty("垂向加速度3")
    private String droopVelocityThree;

    @ApiModelProperty("垂向加速度4")
    private String droopVelocityFour;

    @ApiModelProperty("横向加速度1")
    private String acrossVelocityOne;

    @ApiModelProperty("横向加速度2")
    private String acrossVelocityTwo;

    @ApiModelProperty("横向加速度3")
    private String acrossVelocityThree;

    @ApiModelProperty("横向加速度4")
    private String acrossVelocityFour;

    @ApiModelProperty("曲率变化率1")
    private String curvatureChangeOne;

    @ApiModelProperty("曲率变化率2")
    private String curvatureChangeTwo;

    @ApiModelProperty("轨距变化率1")
    private String trackGaugeChangeOne;

    @ApiModelProperty("轨距变化率2")
    private String trackGaugeChangeTwo;

    @ApiModelProperty("公里扣分")
    private String kilometerDeduct;

    @ApiModelProperty("评定")
    private String evaluate;

    @ApiModelProperty("速度（km/h）")
    private String speed;

    @ApiModelProperty("是否删除（0：未删除； 1：已删除）")
    private String delFlag;

    @ApiModelProperty("导入顺序")
    private Integer sort;


}
