package org.jeecg.modules.checkData.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 * 轨检车-》TQI公里状态评定标准
 * </p>
 *
 * @author hkl
 * @since 2023-07-27
 */
@Data
public class MovementTqiKilometerStandardManagerVO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    private String movementMasterId;

    @ApiModelProperty("评价定义")
    private String evaluate;

    @ApiModelProperty("均衡")
    private String balanced;

    @ApiModelProperty("计划最小值")
    private String minPlan;

    @ApiModelProperty("计划最大值")
    private String maxPlan;

    @ApiModelProperty("优先值")
    private String first;

    @ApiModelProperty("是否删除（0：未删除； 1：已删除）")
    private String delFlag;

    @ApiModelProperty("导入顺序")
    private Integer sort;


}
