package org.jeecg.modules.checkData.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 检查数据-动静态几何尺寸数据-轨检仪静态检查数据-检查项目-明细表
 * </p>
 *
 * @author hkl
 * @since 2023-07-16
 */
@Data
@ApiModel(value = "RailInspectionEquipmentItemDetail对象", description = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-检查项目-明细表")
public class RailInspectionEquipmentItemDetailVO {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("轨检仪静态检查数据id")
    private String railInspectionEquipmentId;

    @ApiModelProperty("轨检仪静态检查数据检查项id")
    private String railInspectionEquipmentItemId;

    @ApiModelProperty("检查项目")
    private String checkItem;

    @ApiModelProperty("测点")
    private Integer measurePoint;

    @ApiModelProperty("轨距")
    private String trackGauge;

    @ApiModelProperty("水平")
    private String level;

    @ApiModelProperty("三角坑")
    private String triangularPit;

    @ApiModelProperty("轨向、高低及其它")
    private String other;

    @ApiModelProperty("排序字段")
    private Integer infoSort;

}
