package org.jeecg.modules.checkData.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 检查数据-设备检查记录数据-钢轨伤损情况检查表
 * </p>
 *
 * @author hkl
 * @since 2023-07-09
 */
@Data
@ApiModel(value = "RailWearRecordDetailVO对象", description = "钢轨伤损情况检查详情")
public class RailWearRecordDetailVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("检查设备id")
    private String deviceProjectId;

    @ApiModelProperty("检查设备code")
    private String deviceProjectCode;

    @ApiModelProperty("检查设备类型（1-钢轨,2-曲线,3-竖曲线,4-道岔）")
    private Integer deviceProjectType;

    @ApiModelProperty("股别(1-左股，2-右股)")
    private Integer damageLevel;

    @ApiModelProperty("伤损钢轨数量")
    private Integer damageNum;

    @ApiModelProperty("伤损里程")
    private BigDecimal damageMileage;

    @ApiModelProperty("伤损种类（1-鱼鳞纹,2-剥落掉块,3-表面疲劳裂纹,4-轨底掉块,5-灼伤,6-核伤,7-焊缝,8-其他）")
    private Integer damageType;

    @ApiModelProperty("伤损程度(1-轻伤,2-轻伤有发展,3-重伤)")
    private Integer damageDegree;

    @ApiModelProperty("换轨计划")
    @TableField("damage_plan")
    private String damagePlan;
}
