package org.jeecg.modules.checkData.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 设备检查记录数据-钢轨波磨情况检查数据-波长
 * </p>
 *
 * @author hkl
 * @since 2023-08-04
 */
@Data
public class RecordsMasterCorrWaveVO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("设备检查记录主表id")
    private String recordsMasterId;

    @ApiModelProperty("类型（1：RMS；2：AP2P；3：FIL）")
    private String type;

    @ApiModelProperty("波长")
    private String wave;

    @ApiModelProperty("值1")
    private BigDecimal numOne;

    @ApiModelProperty("值2")
    private BigDecimal numTwo;

    @ApiModelProperty("值3")
    private BigDecimal numThree;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    private String delFlag;

    @ApiModelProperty("导入顺序")
    private Integer sort;

}
