package org.jeecg.modules.deviceAsset.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.modules.deviceAsset.dto.SwitchManagementQueryDTO;
import org.jeecg.modules.deviceAsset.entity.SwitchManagement;
import org.jeecg.modules.deviceAsset.service.IRailManagementService;
import org.jeecg.modules.deviceAsset.service.ISwitchManagementService;
import org.jeecg.modules.deviceAsset.vo.SwitchManagementQueryVO;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Arrays;

/**
 * @Description: 资产管理-道岔管理
 * @Author: jeecg-boot
 * @Date: 2023-06-14
 * @Version: V1.0
 */
@Api(tags = "资产管理-道岔管理")
@RestController
@RequestMapping("/deviceAsset/switchManagement")
@Slf4j
public class SwitchManagementController extends JeecgController<SwitchManagement, ISwitchManagementService> {
    @Resource
    private IRailManagementService railManagementService;

    @AutoLog(value = "资产管理-道岔管理-分页列表查询")
    @ApiOperation(value = "资产管理-道岔管理-分页列表查询", notes = "资产管理-道岔管理-分页列表查询")
    @GetMapping(value = "/list")
    public Result<IPage<SwitchManagementQueryVO>> queryPageList(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                                @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                                SwitchManagementQueryDTO dto) {
        Page<SwitchManagementQueryVO> pageData = new Page<>(pageNo, pageSize);
        pageData = this.service.queryPageList(pageData, dto);
        return Result.OK(pageData);
    }


    @AutoLog(value = "资产管理-道岔管理-编辑")
    @ApiOperation(value = "资产管理-道岔管理-编辑", notes = "资产管理-道岔管理-编辑")
    @PostMapping(value = "/edit")
    public Result<String> edit(@RequestBody SwitchManagement switchManagement) {
        railManagementService.verifyUnitDeviceConflicts(
                switchManagement.getId(),
                switchManagement.getLightRailId(),
                switchManagement.getLineAliasId(),
                switchManagement.getByroadPreMileage(),
                switchManagement.getByroadEndMileage()
        );

        this.service.edit(switchManagement);


        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "资产管理-道岔管理-通过id删除")
    @ApiOperation(value = "资产管理-道岔管理-通过id删除", notes = "资产管理-道岔管理-通过id删除")
    @GetMapping(value = "/delete")
    public Result<String> delete(@RequestParam(name = "id", required = true) String id) {
        this.service.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "资产管理-道岔管理-批量删除")
    @ApiOperation(value = "线路车站-轻轨线路-批量删除", notes = "线路车站-轻轨线路-批量删除")
    @GetMapping(value = "/deleteBatch")
    public Result<String> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.service.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    @AutoLog(value = "资产管理-道岔管理-校验道岔编码重复")
    @ApiOperation(value = "资产管理-道岔管理-校验道岔编码重复", notes = "资产管理-轨枕管理-校验道岔编码重复")
    @GetMapping(value = "/checkSwitchCodeRepeat")
    public Result<String> checkSwitchCodeRepeat(String id, String lightRailId, String switchCode) {
        Long count = 0L;
        if (ObjectUtil.isNotEmpty(lightRailId)) {
            count = this.service.checkSwitchCodeRepeat(id, lightRailId, switchCode);
        }
        if (count > 0) {
            throw JeecgBootException.error("");
        }
        return Result.OK("未重复");
    }

}
