package org.jeecg.modules.deviceAsset.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 资产管理-竖曲线管理
 * </p>
 *
 * @author hkl
 * @since 2023-07-06
 */
@Getter
@Setter
@TableName("t_da_vertical_curve_management")
@ApiModel(value = "VerticalCurveManagement对象", description = "资产管理-竖曲线管理")
public class VerticalCurveManagement implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableField("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("竖曲线编号")
    @TableField("vertical_curve_code")
    private String verticalCurveCode;

    @ApiModelProperty(value = "单元编码")
    @TableField("unit_code")
    private String unitCode;

    @ApiModelProperty("区间id")
    @TableField("section_id")
    private String sectionId;

    @ApiModelProperty("线别id")
    @TableField("line_alias_id")
    private String lineAliasId;

    @ApiModelProperty("起始里程")
    @TableField("starting_mileage")
    private BigDecimal startingMileage;

    @ApiModelProperty("中心里程")
    @TableField("center_mileage")
    private BigDecimal centerMileage;

    @ApiModelProperty("结束里程")
    @TableField("end_mileage")
    private BigDecimal endMileage;

    @ApiModelProperty("竖曲线半径R(m)")
    @TableField("vertical_curve_adius")
    private BigDecimal verticalCurveAdius;

    @ApiModelProperty("切线长T(m)")
    @TableField("tangent_len")
    private BigDecimal tangentLen;

    @ApiModelProperty("外矢距/E(m)")
    @TableField("apex_distance")
    private BigDecimal apexDistance;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;

    @ApiModelProperty(value = "线路id")
    @TableField(exist = false)
    private String lightRailId;

}
