package org.jeecg.modules.deviceAsset.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;

@Getter
@Setter
public class FastenerManagementVO {
    private static final long serialVersionUID = 1L;

    @TableField("id")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("扣件编号")
    private String fastenerCode;

    @ApiModelProperty("扣件类型")
    private String fastenerType;

    @ApiModelProperty("扣件数量")
    private Integer fastenerNum;

    @ApiModelProperty("线路Id")
    private String lightRailId;

    @ApiModelProperty("线路名称")
    private String lightRailName;

    @ApiModelProperty("区间id")
    private String sectionId;

    @ApiModelProperty("区间名称")
    private String sectionName;

    @ApiModelProperty("线别id")
    private String lineAliasId;

    @ApiModelProperty("线别名称")
    private String lineAliasName;

    @ApiModelProperty("道床Id")
    private String trackBedId;

    @ApiModelProperty("道床编号")
    private String trackBedCode;

    @ApiModelProperty("起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty("结束里程")
    private BigDecimal endMileage;

    @ApiModelProperty("道床长度=结束里程-起始里程")
    private BigDecimal trackBedLen;

    @ApiModelProperty("备注")
    private String remark;
}
