package org.jeecg.modules.deviceAsset.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 资产管理-轨行区标识牌管理
 * </p>
 *
 * @author hkl
 * @since 2023-07-06
 */
@Data
@ApiModel(value = "SignBoardManagementVO对象", description = "资产管理-轨行区标识牌管理")
public class SignBoardManagementVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableField("id")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("轨行区标识牌编号")
    private String signBoardCode;

    @ApiModelProperty("轨行区标识牌类型")
    private String signBoardType;

    @ApiModelProperty("线路id")
    private String lightRailId;

    @ApiModelProperty("线路名称")
    private String lightRailName;

    @ApiModelProperty("区间id")
    private String sectionId;

    @ApiModelProperty("区间名称")
    private String sectionName;

    @ApiModelProperty("线别id")
    private String lineAliasId;

    @ApiModelProperty("线别名称")
    private String lineAliasName;

    @ApiModelProperty("里程")
    private BigDecimal mileage;

    @ApiModelProperty("备注")
    private String remark;

}
