package org.jeecg.modules.deviceAsset.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(value = "资产管理-道岔管理VO")
public class SwitchManagementQueryVO {

    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;

    @ApiModelProperty(value = "创建人")
    private String createBy;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;

    @ApiModelProperty(value = "更新人")
    private String updateBy;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;

    @ApiModelProperty(value = "道岔编号")
    private String switchCode;

    @ApiModelProperty(value = "道岔型号")
    private String switchModel;

    @ApiModelProperty(value = "线别Id")
    private String lineAliasId;

    @ApiModelProperty(value = "线别name")
    private String lineAliasName;

    @ApiModelProperty(value = "线别Id")
    private String lineAliasCode;

    @ApiModelProperty(value = "开向")
    private String openTo;

    @ApiModelProperty(value = "岔前/岔前里程")
    private BigDecimal byroadPreMileage;

    @ApiModelProperty(value = "岔心里程")
    private BigDecimal byroadCenterMileage;

    @ApiModelProperty(value = "岔前/岔后里程")
    private BigDecimal byroadEndMileage;

    @ApiModelProperty(value = "区间车站mapId")
    private String sectionStationMapId;

    @ApiModelProperty(value = "线路id")
    private String lightRailId;

    @ApiModelProperty(value = "线路名称")
    private String lightRailName;

    @ApiModelProperty(value = "区间id")
    private String sectionId;

    @ApiModelProperty(value = "区间名称")
    private String sectionName;

    @ApiModelProperty(value = "车站id")
    private String stationId;

    @ApiModelProperty(value = "车站名称")
    private String stationName;

    @ApiModelProperty(value = "备注")
    private String remark;

}
