package org.jeecg.modules.diseaseAnalysis.algorithm;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.modules.checkData.entity.*;
import org.jeecg.modules.checkData.service.*;
import org.jeecg.modules.deviceAsset.entity.TrackBedManagement;
import org.jeecg.modules.deviceAsset.service.ITrackBedManagementService;
import org.jeecg.modules.diseaseAnalysis.entity.*;
import org.jeecg.modules.diseaseAnalysis.service.*;
import org.jeecg.modules.dynamicStaticAnalysis.mapper.AnalysisAlgorithmMapper;
import org.jeecg.modules.utils.BeanCopyUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestParam;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分析算法
 */
@Service
@Slf4j
public class AnalysisAlgorithmLine {
    @Resource
    private AnalysisAlgorithmMapper analysisAlgorithmMapper;
    @Resource
    private IAnalysisLineBatchService analysisLineBatchService;
    @Resource
    private IAnalysisLineBatchCheckDataMapService analysisLineBatchCheckDataMapService;
    @Resource
    private IAnalysisLineBatchUnitDeviceTurnoutInfoService analysisLineBatchUnitDeviceTurnoutInfoService;
    @Resource
    private IAnalysisLineBatchUnitDeviceRailWearInfoService analysisLineBatchUnitDeviceRailWearInfoService;
    @Resource
    private IAnalysisLineBatchUnitDeviceCurveWearInfoService analysisLineBatchUnitDeviceCurveWearInfoService;
    @Resource
    private IAnalysisLineBatchUnitDeviceCorrugationInfoService analysisLineBatchUnitDeviceCorrugationInfoService;
    @Resource
    private IAnalysisLineBatchUnitDeviceTrackBedInfoService analysisLineBatchUnitDeviceTrackBedInfoService;
    @Resource
    private IAnalysisLineBatchUnitDevicePatrolInfoService analysisLineBatchUnitDevicePatrolInfoService;
    @Resource
    private IAnalysisLineBatchUnitDevicePatrolAssistInfoService analysisLineBatchUnitDevicePatrolAssistInfoService;
    //分析部分
    //***************************************************************************************************************
    //检查部分
    @Resource
    private IRecordsMasterTurnoutInfoService turnoutInfoService;
    @Resource
    private IRailWearRecordService railWearRecordService;
    @Resource
    private ICorrugationRecordService corrugationRecordService;
    @Resource
    private ITrackBedManagementCheckService trackBedManagementCheckService;
    @Resource
    private IRecordPatrolMasterService recordPatrolMasterService;
    @Resource
    private IRecordPatrolMasterInfoService recordPatrolMasterInfoService;
    @Resource
    private IRecordPatrolMasterAssistService recordPatrolMasterAssistService;
    @Resource
    private ICurveWearRecordService curveWearRecordService;
    @Resource
    private IAnalysisLineBatchUnitDeviceService unitDeviceService;
    @Resource
    private IRecordsMasterCheckService masterCheckService;
    @Resource
    private ITrackBedManagementService trackBedManagementService;

    @Transactional
    public void analysisLine(String analysisLineBatchId) {
        // 1.1 获取分析基础数据
        AnalysisLineBatch analysisLineBatch = analysisLineBatchService.getById(analysisLineBatchId);
        //查询该批次所需要分析得采集信息批次
        List<AnalysisLineBatchCheckDataMap> analysisLineBatchCheckDataMapList = analysisLineBatchCheckDataMapService.lambdaQuery().eq(AnalysisLineBatchCheckDataMap::getAnalysisBatchId, analysisLineBatchId).list();

        // 1.2 按公里数正序排序所有1-钢轨,2-曲线,3-竖曲线,4-道岔
        List<Map<String, Object>> unitDeviceList = analysisAlgorithmMapper.getUnitDevice(analysisLineBatch.getLightRailId(), analysisLineBatch.getLineAliasId(), analysisLineBatch.getStartingMileage(), analysisLineBatch.getEndMileage());

        //原来单元信息删除
        LambdaQueryWrapper<AnalysisLineBatchUnitDevice> wrapper2 = Wrappers.lambdaQuery();
        wrapper2.eq(AnalysisLineBatchUnitDevice::getAnalysisBatchId, analysisLineBatch.getId());
        unitDeviceService.remove(wrapper2);

        // 1.4 循环分析检查项目
        for (AnalysisLineBatchCheckDataMap checkDataMap : analysisLineBatchCheckDataMapList) {
            // 检查数据类型 1-道岔检查 2-钢轨常规探伤检查 3-曲线钢轨磨耗检查
            // 4-钢轨波磨检查 5-道床检查 6-线路检查
            if ("1".equals(checkDataMap.getEkType())) {
                //1-道岔检查
                //原来道岔检查单元信息详情删除
                LambdaQueryWrapper<AnalysisLineBatchUnitDeviceTurnoutInfo> wrapper3 = Wrappers.lambdaQuery();
                wrapper3.eq(AnalysisLineBatchUnitDeviceTurnoutInfo::getAnalysisBatchId, analysisLineBatch.getId());
                analysisLineBatchUnitDeviceTurnoutInfoService.remove(wrapper3);
                turnoutCheckDataLineAnalysis(analysisLineBatch, checkDataMap, unitDeviceList);

            } else if ("2".equals(checkDataMap.getEkType())) {
                //2-钢轨常规探伤检查
                //原来钢轨常规探伤检查单元信息详情删除
                LambdaQueryWrapper<AnalysisLineBatchUnitDeviceRailWearInfo> wrapper3 = Wrappers.lambdaQuery();
                wrapper3.eq(AnalysisLineBatchUnitDeviceRailWearInfo::getAnalysisBatchId, analysisLineBatch.getId());
                analysisLineBatchUnitDeviceRailWearInfoService.remove(wrapper3);
                railWearInfoCheckDataLineAnalysis(analysisLineBatch, checkDataMap, unitDeviceList);

            } else if ("3".equals(checkDataMap.getEkType())) {
                //3-曲线钢轨磨耗检查
                //原来曲线钢轨磨耗检查单元信息详情删除
                LambdaQueryWrapper<AnalysisLineBatchUnitDeviceCurveWearInfo> wrapper3 = Wrappers.lambdaQuery();
                wrapper3.eq(AnalysisLineBatchUnitDeviceCurveWearInfo::getAnalysisBatchId, analysisLineBatch.getId());
                analysisLineBatchUnitDeviceCurveWearInfoService.remove(wrapper3);
                curveWearInfoCheckDataAnalysis(analysisLineBatch, checkDataMap, unitDeviceList);

            } else if ("4".equals(checkDataMap.getEkType())) {
                //4-钢轨波磨检查
                //原来钢轨波磨检查单元信息详情删除
                LambdaQueryWrapper<AnalysisLineBatchUnitDeviceCorrugationInfo> wrapper3 = Wrappers.lambdaQuery();
                wrapper3.eq(AnalysisLineBatchUnitDeviceCorrugationInfo::getAnalysisBatchId, analysisLineBatch.getId());
                analysisLineBatchUnitDeviceCorrugationInfoService.remove(wrapper3);
                corrugationInfoCheckDataAnalysis(analysisLineBatch, checkDataMap, unitDeviceList);
            } else if ("5".equals(checkDataMap.getEkType())) {
                //5-道床检查
                //原来道床检查单元信息详情删除
                LambdaQueryWrapper<AnalysisLineBatchUnitDeviceTrackBedInfo> wrapper3 = Wrappers.lambdaQuery();
                wrapper3.eq(AnalysisLineBatchUnitDeviceTrackBedInfo::getAnalysisBatchId, analysisLineBatch.getId());
                analysisLineBatchUnitDeviceTrackBedInfoService.remove(wrapper3);
                trackBedInfoCheckDataAnalysis(analysisLineBatch, checkDataMap);
            } else {
                //6-线路检查
                //原来线路巡查-巡道员检查单元信息详情删除
                LambdaQueryWrapper<AnalysisLineBatchUnitDevicePatrolInfo> wrapper3 = Wrappers.lambdaQuery();
                wrapper3.eq(AnalysisLineBatchUnitDevicePatrolInfo::getAnalysisBatchId, analysisLineBatch.getId());
                analysisLineBatchUnitDevicePatrolInfoService.remove(wrapper3);
                //原来线路巡查-协助巡道员检查单元信息详情删除
                LambdaQueryWrapper<AnalysisLineBatchUnitDevicePatrolAssistInfo> wrapper4 = Wrappers.lambdaQuery();
                wrapper4.eq(AnalysisLineBatchUnitDevicePatrolAssistInfo::getAnalysisBatchId, analysisLineBatch.getId());
                analysisLineBatchUnitDevicePatrolAssistInfoService.remove(wrapper4);
                patrolInfoCheckDataAnalysis(analysisLineBatch, checkDataMap);
            }
        }
        // 分析完成ine
        analysisLineBatchService.lambdaUpdate().set(AnalysisLineBatch::getAnalysisStatus, 99).eq(AnalysisLineBatch::getId, analysisLineBatchId).update();
        analysisLineBatchCheckDataMapService.lambdaUpdate().set(AnalysisLineBatchCheckDataMap::getAnalysisStatus, 99).eq(AnalysisLineBatchCheckDataMap::getAnalysisBatchId, analysisLineBatchId).update();
        log.info("[分析完成]|线程id:【" + Thread.currentThread().getId() + "】=============分析批次ID:【" + analysisLineBatchId + "】");
    }

    /**
     * 病害分析->线路巡查病害分析批次数据、检查批次
     */
    public void patrolInfoCheckDataAnalysis(AnalysisLineBatch analysisLineBatch, AnalysisLineBatchCheckDataMap
            checkDataMap) {
        //初始化单元表
        List<AnalysisLineBatchUnitDevice> unitList = new ArrayList<>();
        //初始化巡道员检查记录详情
        List<AnalysisLineBatchUnitDevicePatrolInfo> unitInfoList = new ArrayList<>();
        //初始化协助巡道员检查记录详情
        List<AnalysisLineBatchUnitDevicePatrolAssistInfo> unitAssistInfoList = new ArrayList<>();
        //获取巡道员检查记录详情
        List<RecordPatrolMasterInfo> ekIfoList = recordPatrolMasterInfoService.lambdaQuery().eq(RecordPatrolMasterInfo::getRecordMasterId, checkDataMap.getEkId()).eq(RecordPatrolMasterInfo::getDelFlag, "0")
                .list();
        //获取协助巡道员检查记录详情
        List<RecordPatrolMasterAssist> ekAssistIfoList = recordPatrolMasterAssistService.lambdaQuery().eq(RecordPatrolMasterAssist::getRecordMasterId, checkDataMap.getEkId()).eq(RecordPatrolMasterAssist::getDelFlag, "0")
                .list();
        if (checkDataMap != null) {
            //保存单元信息
            String deviceId = savePatrolUnit(analysisLineBatch, checkDataMap, unitList, ekIfoList);
            if (CollectionUtils.isNotEmpty(ekIfoList)) {
                ekIfoList.forEach(model -> {
                    //组装分析巡道员检查记录信息详情
                    savePatrolInfoRecordUnitInfo(analysisLineBatch, checkDataMap, unitInfoList, model, deviceId);
                });
            }
            if (CollectionUtils.isNotEmpty(ekAssistIfoList)) {
                ekAssistIfoList.forEach(model -> {
                    //组装分析协助巡道员检查记录信息详情
                    savePatrolAssistInfoRecordUnitInfo(analysisLineBatch, checkDataMap, unitAssistInfoList, model, deviceId);
                });
            }
        }
        if (CollectionUtils.isNotEmpty(unitList)) {
            unitDeviceService.saveBatch(unitList);
        }
        //保存分析巡道员检查记录信息详情
        if (CollectionUtils.isNotEmpty(unitInfoList)) {
            analysisLineBatchUnitDevicePatrolInfoService.saveBatch(unitInfoList);
        }
        //保存分析协助巡道员检查记录信息详情
        if (CollectionUtils.isNotEmpty(unitAssistInfoList)) {
            analysisLineBatchUnitDevicePatrolAssistInfoService.saveBatch(unitAssistInfoList);
        }
    }

    /**
     * 病害分析->道床病害分析批次数据、检查批次
     */
    public void trackBedInfoCheckDataAnalysis(AnalysisLineBatch analysisLineBatch, AnalysisLineBatchCheckDataMap
            checkDataMap) {
        //初始化单元表
        List<AnalysisLineBatchUnitDevice> unitList = new ArrayList<>();
        //初始化钢轨波磨病害分析单元表详情
        List<AnalysisLineBatchUnitDeviceTrackBedInfo> unitInfoList = new ArrayList<>();
        //获取检查记录详情
        List<TrackBedManagementCheck> ekList = trackBedManagementCheckService.lambdaQuery().eq(TrackBedManagementCheck::getRecordsMasterCheckId, checkDataMap.getEkId()).eq(TrackBedManagementCheck::getDelFlag, "0")
                .list();
        if (checkDataMap != null) {
            //保存单元信息
            String deviceId = saveTrackBedUnit(analysisLineBatch, checkDataMap, unitList);
            if (CollectionUtils.isNotEmpty(ekList)) {
                ekList.forEach(model -> {
                    //保存道床单元信息详情
                    saveTrackBedRecordUnitInfo(analysisLineBatch, checkDataMap, unitInfoList, model, deviceId);
                });
            }
        }
        if (CollectionUtils.isNotEmpty(unitList)) {
            unitDeviceService.saveBatch(unitList);
        }
        if (CollectionUtils.isNotEmpty(unitInfoList)) {
            analysisLineBatchUnitDeviceTrackBedInfoService.saveBatch(unitInfoList);
        }
    }

    /**
     * 病害分析->钢轨波磨病害分析批次数据、检查批次、1-钢轨,2-曲线,3-竖曲线,4-道岔
     */
    public void corrugationInfoCheckDataAnalysis(AnalysisLineBatch analysisLineBatch, AnalysisLineBatchCheckDataMap
            checkDataMap, List<Map<String, Object>> unitDeviceList) {
        //初始化单元表
        List<AnalysisLineBatchUnitDevice> unitList = new ArrayList<>();
        //初始化钢轨波磨病害分析单元表详情
        List<AnalysisLineBatchUnitDeviceCorrugationInfo> unitInfoList = new ArrayList<>();
        //获取检查记录详情
        List<CorrugationRecord> ekList = corrugationRecordService.lambdaQuery().eq(CorrugationRecord::getRecordsMasterCheckId, checkDataMap.getEkId()).eq(CorrugationRecord::getDelFlag, "0")
                .list();
        //按设备单元编号分组检查记录详情
        Map<String, List<CorrugationRecord>> deviceProjectList = ekList.stream().collect(Collectors.groupingBy(CorrugationRecord::getDeviceProjectCode));
        if (CollectionUtils.isNotEmpty(ekList)) {
            for (Map<String, Object> map : unitDeviceList) {
                //获取分析批次筛选的单元设备编码
                String unitCode = map.get("unitCode").toString();
                String deviceCode = map.get("deviceCode").toString();
                //保存单元信息
                String deviceId = saveUnit(analysisLineBatch, checkDataMap, map, unitList, deviceCode);
                //判断分析批次的设备与检查时维护的设备是同一个设备
                List<CorrugationRecord> corrugationRecordList = deviceProjectList.get(unitCode);
                if (CollectionUtils.isNotEmpty(corrugationRecordList)) {
                    corrugationRecordList.forEach(model -> {
                        //保存道岔单元信息详情
                        saveCorrugationRecordUnitInfo(analysisLineBatch, checkDataMap, unitInfoList, model, deviceId);
                    });
                }
            }
        }
        if (CollectionUtils.isNotEmpty(unitList)) {
            unitDeviceService.saveBatch(unitList);
        }
        if (CollectionUtils.isNotEmpty(unitInfoList)) {
            analysisLineBatchUnitDeviceCorrugationInfoService.saveBatch(unitInfoList);
        }
    }

    /**
     * 病害分析->曲线磨耗病害分析批次数据、检查批次、1-钢轨,2-曲线,3-竖曲线,4-道岔
     */
    public void curveWearInfoCheckDataAnalysis(AnalysisLineBatch analysisLineBatch, AnalysisLineBatchCheckDataMap
            checkDataMap, List<Map<String, Object>> unitDeviceList) {
        //刷选出曲线和竖曲线的设备
        unitDeviceList = unitDeviceList.stream().filter
                (map -> "2".equals(map.get("type").toString()) || "3".equals(map.get("type").toString())).collect(Collectors.toList());

        //初始化单元表
        List<AnalysisLineBatchUnitDevice> unitList = new ArrayList<>();
        //初始化曲线钢轨磨耗病害分析单元表详情
        List<AnalysisLineBatchUnitDeviceCurveWearInfo> unitInfoList = new ArrayList<>();
        //获取检查记录详情
        List<CurveWearRecord> ekList = curveWearRecordService.lambdaQuery().eq(CurveWearRecord::getRecordsMasterCheckId, checkDataMap.getEkId()).eq(CurveWearRecord::getDelFlag, "0")
                .list();
        //按设备单元编号分组检查记录详情
        Map<String, List<CurveWearRecord>> deviceProjectList = ekList.stream().collect(Collectors.groupingBy(CurveWearRecord::getCurveCode));
        if (CollectionUtils.isNotEmpty(ekList)) {
            for (Map<String, Object> map : unitDeviceList) {
                //获取分析批次筛选的单元设备编码
                String unitCode = map.get("unitCode").toString();
                String deviceCode = map.get("deviceCode").toString();
                //保存单元信息
                String deviceId = saveUnit(analysisLineBatch, checkDataMap, map, unitList, deviceCode);
                //判断分析批次的设备与检查时维护的设备是同一个设备
                List<CurveWearRecord> curveWearRecordList = deviceProjectList.get(unitCode);
                if (CollectionUtils.isNotEmpty(curveWearRecordList)) {
                    curveWearRecordList.forEach(model -> {
                        //保存道岔单元信息详情
                        saveCurveWearRecordUnitInfo(analysisLineBatch, checkDataMap, unitInfoList, model, deviceId);
                    });
                }
            }
        }
        if (CollectionUtils.isNotEmpty(unitList)) {
            unitDeviceService.saveBatch(unitList);
        }
        if (CollectionUtils.isNotEmpty(unitInfoList)) {
            analysisLineBatchUnitDeviceCurveWearInfoService.saveBatch(unitInfoList);
        }
    }

    /**
     * 病害分析->钢轨探伤病害分析批次数据、检查批次、1-钢轨,2-曲线,3-竖曲线,4-道岔
     */
    public void railWearInfoCheckDataLineAnalysis(AnalysisLineBatch analysisLineBatch, AnalysisLineBatchCheckDataMap
            checkDataMap, List<Map<String, Object>> unitDeviceList) {
        //初始化单元表
        List<AnalysisLineBatchUnitDevice> unitList = new ArrayList<>();
        //初始化钢轨探伤病害分析单元表详情
        List<AnalysisLineBatchUnitDeviceRailWearInfo> unitInfoList = new ArrayList<>();
        //获取检查记录详情
        List<RailWearRecord> ekList = railWearRecordService.lambdaQuery().eq(RailWearRecord::getRecordsMasterCheckId, checkDataMap.getEkId()).eq(RailWearRecord::getDelFlag, "0")
                .list();
        //按道岔编号分组检查记录详情
        Map<String, List<RailWearRecord>> deviceProjectList = ekList.stream().collect(Collectors.groupingBy(RailWearRecord::getDeviceProjectCode));
        if (CollectionUtils.isNotEmpty(ekList)) {
            for (Map<String, Object> map : unitDeviceList) {
                //获取分析批次筛选的单元设备编码
                String unitCode = map.get("unitCode").toString();
                String deviceCode = map.get("deviceCode").toString();
                //保存单元信息
                String deviceId = saveUnit(analysisLineBatch, checkDataMap, map, unitList, deviceCode);
                //判断分析批次的设备与检查时维护的设备是同一个设备
                List<RailWearRecord> railWearRecordList = deviceProjectList.get(unitCode);
                if (CollectionUtils.isNotEmpty(railWearRecordList)) {
                    railWearRecordList.forEach(model -> {
                        //保存道岔单元信息详情
                        saveRailWearRecordUnitInfo(analysisLineBatch, checkDataMap, unitInfoList, model, deviceId);
                    });
                }
            }
        }
        if (CollectionUtils.isNotEmpty(unitList)) {
            unitDeviceService.saveBatch(unitList);
        }
        if (CollectionUtils.isNotEmpty(unitInfoList)) {
            analysisLineBatchUnitDeviceRailWearInfoService.saveBatch(unitInfoList);
        }
    }

    /**
     * 病害分析->道岔病害分析批次数据、检查批次、1-钢轨,2-曲线,3-竖曲线,4-道岔
     */
    public void turnoutCheckDataLineAnalysis(AnalysisLineBatch analysisLineBatch, AnalysisLineBatchCheckDataMap
            checkDataMap, List<Map<String, Object>> unitDeviceList) {
        //刷选出道岔的设备
        unitDeviceList = unitDeviceList.stream().filter
                (map -> "4".equals(map.get("type").toString())).collect(Collectors.toList());
        //初始化单元表
        List<AnalysisLineBatchUnitDevice> unitList = new ArrayList<>();
        //初始化单元表道岔详情
        List<AnalysisLineBatchUnitDeviceTurnoutInfo> unitInfoList = new ArrayList<>();
        //获取检查记录详情
        List<RecordsMasterTurnoutInfo> ekList = turnoutInfoService.lambdaQuery().eq(RecordsMasterTurnoutInfo::getRecordsMasterId, checkDataMap.getEkId()).eq(RecordsMasterTurnoutInfo::getDelFlag, "0")
                .list();
        //按道岔编号分组检查记录详情
        Map<String, List<RecordsMasterTurnoutInfo>> switchCodeList = ekList.stream().collect(Collectors.groupingBy(RecordsMasterTurnoutInfo::getSwitchCode));
        if (CollectionUtils.isNotEmpty(ekList)) {
            for (Map<String, Object> map : unitDeviceList) {
                //获取分析批次筛选的道岔编号
                String deviceCode = map.get("deviceCode").toString();
                //保存单元信息
                String deviceId = saveUnit(analysisLineBatch, checkDataMap, map, unitList, deviceCode);
                //判断分析批次的道岔编号在检查时维护的道岔编号是同一个编号
                List<RecordsMasterTurnoutInfo> recordsMasterTurnoutInfoList = switchCodeList.get(deviceCode);
                if (CollectionUtils.isNotEmpty(recordsMasterTurnoutInfoList)) {
                    recordsMasterTurnoutInfoList.forEach(model -> {
                        //保存道岔单元信息详情
                        saveUnitInfo(analysisLineBatch, checkDataMap, unitInfoList, model, deviceId);
                    });
                }
            }
        }
        if (CollectionUtils.isNotEmpty(unitList)) {
            unitDeviceService.saveBatch(unitList);
        }
        if (CollectionUtils.isNotEmpty(unitInfoList)) {
            analysisLineBatchUnitDeviceTurnoutInfoService.saveBatch(unitInfoList);
        }
    }
//*********************************单元表维护公共方法封装******************************************************************

    /**
     * 线路单元
     *
     * @param analysisLineBatch 分析主表
     * @param checkDataMap      分析表对应的检查表关系表
     * @param unitList          最终封装到的集合
     */
    public String savePatrolUnit(AnalysisLineBatch analysisLineBatch, AnalysisLineBatchCheckDataMap
            checkDataMap, List<AnalysisLineBatchUnitDevice> unitList,List<RecordPatrolMasterInfo> ekIfoList) {

        //维护单元表
        AnalysisLineBatchUnitDevice unit = new AnalysisLineBatchUnitDevice();
        unit.setId(UUIDGenerator.generate());
        unit.setAnalysisBatchId(analysisLineBatch.getId());
        unit.setAnalysisBatchCode(analysisLineBatch.getAnalysisBatchCode());
        unit.setEkCode(checkDataMap.getEkCode());
        unit.setEkId(checkDataMap.getEkId());
        unit.setUnitStartMileage(checkDataMap.getStartingMileage());
        unit.setUnitEndMileage(checkDataMap.getEndMileage());
        unit.setWorkStatus(1);
        unit.setCreateBy(checkDataMap.getCreateBy());
        unit.setUpdateBy(checkDataMap.getUpdateBy());
        //线路巡查主表
        RecordPatrolMaster recordPatrolMaster = recordPatrolMasterService.getById(checkDataMap.getEkId());
        if (recordPatrolMaster != null) {
            unit.setRemark(recordPatrolMaster.getRemark());
        }
        //检查结果
        ekIfoList = ekIfoList.stream().filter
                (map -> "1".equals(map.getStatus())).collect(Collectors.toList());

        if(CollectionUtils.isNotEmpty(ekIfoList)){
            unit.setCheckStatus(2);
            unit.setMarkStatus(2);
        }else {
            unit.setCheckStatus(1);
            unit.setMarkStatus(3);
        }
        unitList.add(unit);
        return unit.getId();
    }

    /**
     * 道床单元
     *
     * @param analysisLineBatch 分析主表
     * @param checkDataMap      分析表对应的检查表关系表
     * @param unitList          最终封装到的集合
     */
    public String saveTrackBedUnit(AnalysisLineBatch analysisLineBatch, AnalysisLineBatchCheckDataMap
            checkDataMap, List<AnalysisLineBatchUnitDevice> unitList) {

        //维护单元表
        AnalysisLineBatchUnitDevice unit = new AnalysisLineBatchUnitDevice();
        unit.setId(UUIDGenerator.generate());
        unit.setAnalysisBatchId(analysisLineBatch.getId());
        unit.setAnalysisBatchCode(analysisLineBatch.getAnalysisBatchCode());
        unit.setEkCode(checkDataMap.getEkCode());
        unit.setEkId(checkDataMap.getEkId());
        unit.setUnitStartMileage(checkDataMap.getStartingMileage());
        unit.setUnitEndMileage(checkDataMap.getEndMileage());
        unit.setWorkStatus(1);
        unit.setMarkStatus(1);
        unit.setCreateBy(checkDataMap.getCreateBy());
        unit.setUpdateBy(checkDataMap.getUpdateBy());
        unit.setRemark(analysisLineBatch.getRemark());
        unitList.add(unit);
        return unit.getId();
    }

    /**
     * @param analysisLineBatch 分析主表
     * @param checkDataMap      分析表对应的检查表关系表
     * @param map               分析表内符合的设备信息
     * @param unitList          最终封装到的集合
     * @param switchCode        设备编码
     */
    public String saveUnit(AnalysisLineBatch analysisLineBatch, AnalysisLineBatchCheckDataMap
            checkDataMap, Map<String, Object> map, List<AnalysisLineBatchUnitDevice> unitList, String switchCode) {

        //维护单元表
        AnalysisLineBatchUnitDevice unit = new AnalysisLineBatchUnitDevice();
        unit.setId(UUIDGenerator.generate());
        unit.setAnalysisBatchId(analysisLineBatch.getId());
        unit.setAnalysisBatchCode(analysisLineBatch.getAnalysisBatchCode());
        unit.setEkCode(checkDataMap.getEkCode());
        unit.setEkId(checkDataMap.getEkId());
        unit.setUnitId(map.get("id").toString());
        unit.setUnitCode(map.get("unitCode").toString());
        unit.setUnitType(Integer.valueOf(map.get("type").toString()));
        unit.setUnitTypeName(map.get("typeName").toString());
        unit.setUnitDeviceCode(switchCode);
        unit.setUnitStartMileage(new BigDecimal(map.get("startMileage").toString()));
        unit.setUnitCenterMileage(new BigDecimal(map.get("centerMileage").toString()));
        unit.setUnitEndMileage(new BigDecimal(map.get("endMileage").toString()));
        unit.setWorkStatus(1);
        unit.setMarkStatus(1);
        unit.setCreateBy(checkDataMap.getCreateBy());
        unit.setUpdateBy(checkDataMap.getUpdateBy());
        unit.setRemark(analysisLineBatch.getRemark());
        unitList.add(unit);
        return unit.getId();
    }

    /**
     * 道岔病害分析数据存储
     *
     * @param analysisLineBatch 分析主表
     * @param checkDataMap      分析表对应的检查表关系表
     * @param unitInfoList      最终封装到的集合
     * @param info              检查记录详情
     * @param deviceId          单元表id
     */
    public void saveUnitInfo(AnalysisLineBatch analysisLineBatch, AnalysisLineBatchCheckDataMap
            checkDataMap, List<AnalysisLineBatchUnitDeviceTurnoutInfo> unitInfoList, RecordsMasterTurnoutInfo info, String deviceId) {

        //维护单元详情表
        AnalysisLineBatchUnitDeviceTurnoutInfo unitInfo = new AnalysisLineBatchUnitDeviceTurnoutInfo();
        BeanCopyUtil.copyProperties(info, unitInfo);
        unitInfo.setId(UUIDGenerator.generate());
        unitInfo.setDeviceId(deviceId);
        unitInfo.setAnalysisBatchId(analysisLineBatch.getId());
        unitInfo.setAnalysisBatchCode(analysisLineBatch.getAnalysisBatchCode());
        unitInfo.setEkCode(checkDataMap.getEkCode());
        unitInfo.setEkId(checkDataMap.getEkId());
        unitInfo.setGaugeCode(masterCheckService.getById(checkDataMap.getEkId()).getGaugeCode());
        unitInfo.setType(info.getType());
        unitInfo.setDelFlag("0");
        unitInfoList.add(unitInfo);
    }

    /**
     * 钢轨探伤病害分析单元详情维护
     *
     * @param analysisLineBatch 分析主表
     * @param checkDataMap      分析表对应的检查表关系表
     * @param unitInfoList      最终封装到的集合
     * @param info              检查记录详情
     * @param deviceId          单元表id
     */
    public void saveRailWearRecordUnitInfo(AnalysisLineBatch analysisLineBatch, AnalysisLineBatchCheckDataMap
            checkDataMap, List<AnalysisLineBatchUnitDeviceRailWearInfo> unitInfoList, RailWearRecord info, String deviceId) {

        //维护单元详情表
        AnalysisLineBatchUnitDeviceRailWearInfo unitInfo = new AnalysisLineBatchUnitDeviceRailWearInfo();
        BeanCopyUtil.copyProperties(info, unitInfo);
        unitInfo.setId(UUIDGenerator.generate());
        unitInfo.setDeviceId(deviceId);
        unitInfo.setAnalysisBatchId(analysisLineBatch.getId());
        unitInfo.setAnalysisBatchCode(analysisLineBatch.getAnalysisBatchCode());
        unitInfo.setEkCode(checkDataMap.getEkCode());
        unitInfo.setEkId(checkDataMap.getEkId());
        unitInfo.setDelFlag("0");
        unitInfoList.add(unitInfo);
    }

    /**
     * 曲线磨耗病害分析单元详情维护
     *
     * @param analysisLineBatch 分析主表
     * @param checkDataMap      分析表对应的检查表关系表
     * @param unitInfoList      最终封装到的集合
     * @param info              检查记录详情
     * @param deviceId          单元表id
     */
    public void saveCurveWearRecordUnitInfo(AnalysisLineBatch analysisLineBatch, AnalysisLineBatchCheckDataMap
            checkDataMap, List<AnalysisLineBatchUnitDeviceCurveWearInfo> unitInfoList, CurveWearRecord info, String deviceId) {

        //维护单元详情表
        AnalysisLineBatchUnitDeviceCurveWearInfo unitInfo = new AnalysisLineBatchUnitDeviceCurveWearInfo();
        BeanCopyUtil.copyProperties(info, unitInfo);
        unitInfo.setId(UUIDGenerator.generate());
        unitInfo.setDeviceId(deviceId);
        unitInfo.setAnalysisBatchId(analysisLineBatch.getId());
        unitInfo.setAnalysisBatchCode(analysisLineBatch.getAnalysisBatchCode());
        unitInfo.setEkCode(checkDataMap.getEkCode());
        unitInfo.setEkId(checkDataMap.getEkId());
        unitInfo.setDeviceProjectId(info.getCurveId());
        unitInfo.setDeviceProjectCode(info.getCurveCode());
        unitInfo.setDeviceProjectType(info.getProjectType());
        unitInfo.setDelFlag("0");
        unitInfoList.add(unitInfo);
    }

    /**
     * 钢轨波磨病害分析单元详情维护
     *
     * @param analysisLineBatch 分析主表
     * @param checkDataMap      分析表对应的检查表关系表
     * @param unitInfoList      最终封装到的集合
     * @param info              检查记录详情
     * @param deviceId          单元表id
     */
    public void saveCorrugationRecordUnitInfo(AnalysisLineBatch analysisLineBatch, AnalysisLineBatchCheckDataMap
            checkDataMap, List<AnalysisLineBatchUnitDeviceCorrugationInfo> unitInfoList, CorrugationRecord info, String deviceId) {

        //维护单元详情表
        AnalysisLineBatchUnitDeviceCorrugationInfo unitInfo = new AnalysisLineBatchUnitDeviceCorrugationInfo();
        BeanCopyUtil.copyProperties(info, unitInfo);
        unitInfo.setId(UUIDGenerator.generate());
        unitInfo.setDeviceId(deviceId);
        unitInfo.setAnalysisBatchId(analysisLineBatch.getId());
        unitInfo.setAnalysisBatchCode(analysisLineBatch.getAnalysisBatchCode());
        unitInfo.setEkCode(checkDataMap.getEkCode());
        unitInfo.setEkId(checkDataMap.getEkId());
        unitInfo.setDelFlag("0");
        unitInfoList.add(unitInfo);
    }

    /**
     * 道床病害分析单元详情维护
     *
     * @param analysisLineBatch 分析主表
     * @param checkDataMap      分析表对应的检查表关系表
     * @param unitInfoList      最终封装到的集合
     * @param info              检查记录详情
     * @param deviceId          单元表id
     */
    public void saveTrackBedRecordUnitInfo(AnalysisLineBatch analysisLineBatch, AnalysisLineBatchCheckDataMap
            checkDataMap, List<AnalysisLineBatchUnitDeviceTrackBedInfo> unitInfoList, TrackBedManagementCheck info, String deviceId) {

        //维护单元详情表
        AnalysisLineBatchUnitDeviceTrackBedInfo unitInfo = new AnalysisLineBatchUnitDeviceTrackBedInfo();
        BeanCopyUtil.copyProperties(info, unitInfo);
        unitInfo.setId(UUIDGenerator.generate());
        unitInfo.setDeviceId(deviceId);
        unitInfo.setAnalysisBatchId(analysisLineBatch.getId());
        unitInfo.setAnalysisBatchCode(analysisLineBatch.getAnalysisBatchCode());
        unitInfo.setEkCode(checkDataMap.getEkCode());
        unitInfo.setEkId(checkDataMap.getEkId());
        TrackBedManagement trackBedManagement = trackBedManagementService.getById(info.getTrakBedManagementId());
        unitInfo.setTrackBedId(trackBedManagement.getId());
        unitInfo.setTrackBedCode(trackBedManagement.getTrackBedCode());
        unitInfo.setTrackBedType(trackBedManagement.getTrackBedType());
        unitInfo.setStartingMileage(trackBedManagement.getStartingMileage());
        unitInfo.setEndMileage(trackBedManagement.getEndMileage());
        unitInfo.setTrackBedLen(trackBedManagement.getTrackBedLen());
        unitInfo.setDelFlag("0");
        unitInfoList.add(unitInfo);
    }
    /**
     * 线路巡查病害分析巡道员巡查单元详情维护
     *
     * @param analysisLineBatch 分析主表
     * @param checkDataMap      分析表对应的检查表关系表
     * @param unitInfoList      最终封装到的集合
     * @param info              检查记录详情
     * @param deviceId          单元表id
     */
    public void savePatrolInfoRecordUnitInfo(AnalysisLineBatch analysisLineBatch, AnalysisLineBatchCheckDataMap
            checkDataMap, List<AnalysisLineBatchUnitDevicePatrolInfo> unitInfoList, RecordPatrolMasterInfo info, String deviceId) {

        //维护单元详情表
        AnalysisLineBatchUnitDevicePatrolInfo unitInfo = new AnalysisLineBatchUnitDevicePatrolInfo();
        BeanCopyUtil.copyProperties(info, unitInfo);
        unitInfo.setId(UUIDGenerator.generate());
        unitInfo.setDeviceId(deviceId);
        unitInfo.setAnalysisBatchId(analysisLineBatch.getId());
        unitInfo.setAnalysisBatchCode(analysisLineBatch.getAnalysisBatchCode());
        unitInfo.setEkCode(checkDataMap.getEkCode());
        unitInfo.setEkId(checkDataMap.getEkId());
        unitInfo.setDelFlag("0");
        unitInfoList.add(unitInfo);
    }
    /**
     * 线路巡查病害分析协助巡道员巡查单元详情维护
     *
     * @param analysisLineBatch 分析主表
     * @param checkDataMap      分析表对应的检查表关系表
     * @param unitInfoList      最终封装到的集合
     * @param info              检查记录详情
     * @param deviceId          单元表id
     */
    public void savePatrolAssistInfoRecordUnitInfo(AnalysisLineBatch analysisLineBatch, AnalysisLineBatchCheckDataMap
            checkDataMap, List<AnalysisLineBatchUnitDevicePatrolAssistInfo> unitInfoList, RecordPatrolMasterAssist info, String deviceId) {

        //维护单元详情表
        AnalysisLineBatchUnitDevicePatrolAssistInfo unitInfo = new AnalysisLineBatchUnitDevicePatrolAssistInfo();
        BeanCopyUtil.copyProperties(info, unitInfo);
        unitInfo.setId(UUIDGenerator.generate());
        unitInfo.setDeviceId(deviceId);
        unitInfo.setAnalysisBatchId(analysisLineBatch.getId());
        unitInfo.setAnalysisBatchCode(analysisLineBatch.getAnalysisBatchCode());
        unitInfo.setEkCode(checkDataMap.getEkCode());
        unitInfo.setEkId(checkDataMap.getEkId());
        unitInfo.setDelFlag("0");
        unitInfoList.add(unitInfo);
    }

}
