package org.jeecg.modules.diseaseAnalysis.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import org.jeecg.modules.diseaseAnalysis.dto.*;
import org.jeecg.modules.diseaseAnalysis.entity.AnalysisLineBatch;
import org.jeecg.modules.diseaseAnalysis.vo.*;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 线路质量分析	-分析批次表 服务类
 * </p>
 *
 * @author hkl
 * @since 2024-07-19
 */
public interface IAnalysisLineBatchService extends IService<AnalysisLineBatch> {
    /**
     * 线路质量分析-其他病害分析-检查记录-分页列表查询
     * @param pageData
     * @param dto
     * @return
     */
    Page<EkRecordsMasterCheckVO> queryPageEkList(Page<EkRecordsMasterCheckVO> pageData, EkRecordsMasterCheckDTO dto);
    /**
     * 线路质量分析-其他病害分析-线路巡查检查记录-分页列表查询
     * @param pageData
     * @param dto
     * @return
     */
    Page<EkRecordPatrolMasterVO> queryPageEkPatrolList(Page<EkRecordPatrolMasterVO> pageData, EkRecordsMasterCheckDTO dto);

    /**
     * 线路质量分析-其他病害分析-分页列表查询
     * @param pageData
     * @param dto
     * @return
     */
    Page<AnalysisLineBatchVO> getPageList(Page<AnalysisLineBatchVO> pageData, AnalysisLineBatchDTO dto);

    /**
     * 获取是否可编辑列表
     * @param analysisBatchIds
     * @return
     */
    List<Map<String, Object>> getIsEditList(List<String> analysisBatchIds);
    /**
     * 获取分析批次对应得检查批次信息
     * @param analysisLineBatchIds 分析批次id集合
     * @return
     */
    List<AnalysisLineBatchCheckDataMapVO> listRecordDetail(List<String> analysisLineBatchIds);

    /**
     * 线路质量分析-其他病害分析-详情查询-分页列表查询
     * @param pageData
     * @param dto
     * @return
     */
    Page<AnalysisLineBatchUnitDeviceVO> getInfoPageList(Page<AnalysisLineBatchUnitDeviceVO> pageData, AnalysisLineBatchInfoDTO dto);

    /**
     * 线路质量分析-其他病害分析-详情检查记录查询
     * @param analysisBatchId 分析批次id
     * @param ekId 检查批次id
     * @param deviceId 线路质量分析-其他病害分析-单元表id
     * @return
     */
    List<AnalysisLineBatchUnitDeviceTurnoutInfoVO> getAnalysisLineBatchUnitEkInfoList(String analysisBatchId, String ekId, String deviceId);

    /**
     * 线路质量分析-其他病害分析-钢轨探伤单元详情检查记录查询
     * @param analysisBatchId
     * @param ekId
     * @param deviceId
     * @return
     */
    List<AnalysisLineBatchUnitDeviceRailWearInfoVO> getAnalysisLineBatchUnitDeviceRailWearInfoList(String analysisBatchId, String ekId, String deviceId);

    /**
     * 线路质量分析-其他病害分析-钢轨波磨单元详情检查记录查询
     * @param analysisBatchId
     * @param ekId
     * @param deviceId
     * @return
     */
    List<AnalysisLineBatchUnitDeviceCorrugationInfoVO> getAnalysisLineBatchUnitDeviceCorrugationInfoList(String analysisBatchId, String ekId, String deviceId);
    /**
     * 线路质量分析-其他病害分析-曲线波磨单元详情检查记录查询
     * @param analysisBatchId
     * @param ekId
     * @param deviceId
     * @return
     */
    List<AnalysisLineBatchUnitDeviceCurveWearInfoVO> getAnalysisLineBatchUnitDeviceCurveWearInfoList(String analysisBatchId, String ekId, String deviceId);
    /**
     * 线路质量分析-其他病害分析-道床单元详情检查记录查询
     * @param analysisBatchId
     * @param ekId
     * @param deviceId
     * @return
     */
    List<AnalysisLineBatchUnitDeviceTrackBedInfoVO> getAnalysisLineBatchUnitDeviceTrackBedInfoList(String analysisBatchId, String ekId, String deviceId);
    /**
     * 线路质量分析-其他病害分析-线路巡查巡道员检查详情
     *
     * @param analysisBatchId 分析批次id
     * @param ekId            检查批次id
     * @param deviceId        线路质量分析-其他病害分析-单元表id
     * @return
     */
    List<AnalysisLineBatchUnitDevicePatrolInfoVO> getAnalysisLineBatchUnitDevicePatrolInfoList(String analysisBatchId, String ekId, String deviceId);
    /**
     * 线路质量分析-其他病害分析-线路巡查协助巡道员检查详情
     *
     * @param analysisBatchId 分析批次id
     * @param ekId            检查批次id
     * @param deviceId        线路质量分析-其他病害分析-单元表id
     * @return
     */
    List<AnalysisLineBatchUnitDevicePatrolAssistInfoVO> getAnalysisLineBatchUnitDevicePatrolAssistInfoList(String analysisBatchId, String ekId, String deviceId);

    /**
     * 维修作业管理-选择分析批次-列表分页查询
     * @param pageData
     * @param dto
     * @return
     */
    Page<AnalysisLineBatchWorkVO> getWorkPageList(Page<AnalysisLineBatchWorkVO> pageData, AnalysisLineBatchWorkDTO dto);


    /**
     *其他病害分析-分析批次-新增分析批次
     * @param dto
     */
    void saveRecord(AnalysisLineBatchSaveOrUpdateDTO dto);

    /**
     * 其他病害分析-分析批次-更新分析批次
     * @param dto
     */
    void updateRecord(AnalysisLineBatchSaveOrUpdateDTO dto);

    /**
     * 其他病害分析-分析批次-删除
     * @param idList
     */
    void deleteBatchRecord(List<String> idList,Integer type);

    /**
     * 其他病害分析-分析批次-更新分析单元标记状态
     * @param id
     * @param status
     */
    void updateRecordMarkStatus(String id,Integer status);
}
