package org.jeecg.modules.diseaseAnalysis.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.modules.diseaseAnalysis.algorithm.MultiProducerLine;
import org.jeecg.modules.diseaseAnalysis.dto.*;
import org.jeecg.modules.diseaseAnalysis.entity.*;
import org.jeecg.modules.diseaseAnalysis.mapper.*;
import org.jeecg.modules.diseaseAnalysis.service.IAnalysisLineBatchService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.modules.diseaseAnalysis.vo.*;
import org.jeecg.modules.maintenanceWork.entity.WorkBatchDetail;
import org.jeecg.modules.maintenanceWork.service.IWorkBatchDetailService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 线路质量分析	-分析批次表 服务实现类
 * </p>
 *
 * @author hkl
 * @since 2024-07-19
 */
@Service
public class AnalysisLineBatchServiceImpl extends ServiceImpl<AnalysisLineBatchMapper, AnalysisLineBatch> implements IAnalysisLineBatchService {
    @Resource
    private AnalysisLineBatchCheckDataMapMapper analysisLineBatchCheckDataMapMapper;
    @Resource
    private AnalysisLineBatchUnitDeviceMapper analysisLineBatchUnitDeviceMapper;
    @Resource
    private AnalysisLineBatchUnitDeviceTurnoutInfoMapper analysisLineBatchUnitDeviceTurnoutInfoMapper;
    @Resource
    private AnalysisLineBatchUnitDeviceRailWearInfoMapper analysisLineBatchUnitDeviceRailWearInfoMapper;
    @Resource
    private AnalysisLineBatchUnitDeviceCurveWearInfoMapper analysisLineBatchUnitDeviceCurveWearInfoMapper;
    @Resource
    private AnalysisLineBatchUnitDeviceCorrugationInfoMapper analysisLineBatchUnitDeviceCorrugationInfoMapper;
    @Resource
    private AnalysisLineBatchUnitDeviceTrackBedInfoMapper analysisLineBatchUnitDeviceTrackBedInfoMapper;
    @Resource
    private AnalysisLineBatchUnitDevicePatrolInfoMapper analysisLineBatchUnitDevicePatrolInfoMapper;
    @Resource
    private AnalysisLineBatchUnitDevicePatrolAssistInfoMapper analysisLineBatchUnitDevicePatrolAssistInfoMapper;
    @Resource
    private IWorkBatchDetailService workBatchDetailService;
    /**
     * 线路质量分析-其他病害分析-检查记录-分页列表查询
     *
     * @param pageData
     * @param dto
     * @return
     */
    @Override
    public Page<EkRecordsMasterCheckVO> queryPageEkList(Page<EkRecordsMasterCheckVO> pageData, EkRecordsMasterCheckDTO dto) {
        return this.baseMapper.queryPageEkList(pageData, dto);
    }

    /**
     * 线路质量分析-其他病害分析-线路巡查检查记录-分页列表查询
     *
     * @param pageData
     * @param dto
     * @return
     */
    @Override
    public Page<EkRecordPatrolMasterVO> queryPageEkPatrolList(Page<EkRecordPatrolMasterVO> pageData, EkRecordsMasterCheckDTO dto) {
        return this.baseMapper.queryPageEkPatrolList(pageData, dto);
    }

    /**
     * 线路质量分析-其他病害分析-分页列表查询
     *
     * @param pageData
     * @param dto
     * @return
     */
    @Override
    public Page<AnalysisLineBatchVO> getPageList(Page<AnalysisLineBatchVO> pageData, AnalysisLineBatchDTO dto) {
        return this.baseMapper.getPageList(pageData, dto);
    }
    /**
     * 获取是否可编辑列表
     * @param analysisBatchIds
     * @return
     */
    @Override
    public List<Map<String, Object>> getIsEditList(List<String> analysisBatchIds) {
        return this.baseMapper.getIsEditList(analysisBatchIds);
    }

    /**
     * 获取分析批次对应得检查批次信息
     *
     * @param analysisLineBatchIds 分析批次id集合
     * @return
     */
    @Override
    public List<AnalysisLineBatchCheckDataMapVO> listRecordDetail(List<String> analysisLineBatchIds) {
        return this.baseMapper.listRecordDetail(analysisLineBatchIds);
    }

    /**
     * 线路质量分析-其他病害分析-详情查询-分页列表查询
     *
     * @param pageData
     * @param dto
     * @return
     */
    @Override
    public Page<AnalysisLineBatchUnitDeviceVO> getInfoPageList(Page<AnalysisLineBatchUnitDeviceVO> pageData, AnalysisLineBatchInfoDTO dto) {
        return this.baseMapper.getInfoPageList(pageData, dto);
    }

    /**
     * 线路质量分析-其他病害分析-详情检查记录查询
     *
     * @param analysisBatchId 分析批次id
     * @param ekId            检查批次id
     * @param deviceId        线路质量分析-其他病害分析-单元表id
     * @return
     */
    @Override
    public List<AnalysisLineBatchUnitDeviceTurnoutInfoVO> getAnalysisLineBatchUnitEkInfoList(String analysisBatchId, String ekId, String deviceId) {
        List<AnalysisLineBatchUnitDeviceTurnoutInfoVO> list = this.baseMapper.getAnalysisLineBatchUnitEkInfoList(analysisBatchId, ekId, deviceId);
        return list;
    }

    /**
     * 线路质量分析-其他病害分析-钢轨探伤单元详情检查记录查询
     *
     * @param analysisBatchId 分析批次id
     * @param ekId            检查批次id
     * @param deviceId        线路质量分析-其他病害分析-单元表id
     * @return
     */
    @Override
    public List<AnalysisLineBatchUnitDeviceRailWearInfoVO> getAnalysisLineBatchUnitDeviceRailWearInfoList(String analysisBatchId, String ekId, String deviceId) {
        List<AnalysisLineBatchUnitDeviceRailWearInfoVO> list = this.baseMapper.getAnalysisLineBatchUnitDeviceRailWearInfoList(analysisBatchId, ekId, deviceId);
        return list;
    }

    /**
     * 线路质量分析-其他病害分析-钢轨波磨单元详情检查记录查询
     * @param analysisBatchId
     * @param ekId
     * @param deviceId
     * @return
     */
    @Override
    public List<AnalysisLineBatchUnitDeviceCorrugationInfoVO> getAnalysisLineBatchUnitDeviceCorrugationInfoList(String analysisBatchId, String ekId, String deviceId) {
        List<AnalysisLineBatchUnitDeviceCorrugationInfoVO> list = this.baseMapper.getAnalysisLineBatchUnitDeviceCorrugationInfoList(analysisBatchId, ekId, deviceId);
        return list;
    }
    /**
     * 线路质量分析-其他病害分析-曲线波磨单元详情检查记录查询
     * @param analysisBatchId
     * @param ekId
     * @param deviceId
     * @return
     */
    @Override
    public List<AnalysisLineBatchUnitDeviceCurveWearInfoVO> getAnalysisLineBatchUnitDeviceCurveWearInfoList(String analysisBatchId, String ekId, String deviceId) {
        List<AnalysisLineBatchUnitDeviceCurveWearInfoVO> list = this.baseMapper.getAnalysisLineBatchUnitDeviceCurveWearInfoList(analysisBatchId, ekId, deviceId);
        return list;
    }
    /**
     * 线路质量分析-其他病害分析-道床单元详情检查记录查询
     * @param analysisBatchId
     * @param ekId
     * @param deviceId
     * @return
     */
    @Override
    public List<AnalysisLineBatchUnitDeviceTrackBedInfoVO> getAnalysisLineBatchUnitDeviceTrackBedInfoList(String analysisBatchId, String ekId, String deviceId) {
        List<AnalysisLineBatchUnitDeviceTrackBedInfoVO> list = this.baseMapper.getAnalysisLineBatchUnitDeviceTrackBedInfoList(analysisBatchId, ekId, deviceId);
        return list;
    }
    /**
     * 线路质量分析-其他病害分析-线路巡查巡道员检查详情
     *
     * @param analysisBatchId 分析批次id
     * @param ekId            检查批次id
     * @param deviceId        线路质量分析-其他病害分析-单元表id
     * @return
     */
    @Override
    public List<AnalysisLineBatchUnitDevicePatrolInfoVO> getAnalysisLineBatchUnitDevicePatrolInfoList(String analysisBatchId, String ekId, String deviceId) {
        List<AnalysisLineBatchUnitDevicePatrolInfoVO> list = this.baseMapper.getAnalysisLineBatchUnitDevicePatrolInfoList(analysisBatchId, ekId, deviceId);
        return list;
    }
    /**
     * 线路质量分析-其他病害分析-线路巡查协助巡道员检查详情
     *
     * @param analysisBatchId 分析批次id
     * @param ekId            检查批次id
     * @param deviceId        线路质量分析-其他病害分析-单元表id
     * @return
     */
    @Override
    public List<AnalysisLineBatchUnitDevicePatrolAssistInfoVO> getAnalysisLineBatchUnitDevicePatrolAssistInfoList(String analysisBatchId, String ekId, String deviceId) {
        List<AnalysisLineBatchUnitDevicePatrolAssistInfoVO> list = this.baseMapper.getAnalysisLineBatchUnitDevicePatrolAssistInfoList(analysisBatchId, ekId, deviceId);
        return list;
    }

    /**
     * 维修作业管理-选择分析批次-列表分页查询
     * @param pageData
     * @param dto
     * @return
     */
    @Override
    public Page<AnalysisLineBatchWorkVO> getWorkPageList(Page<AnalysisLineBatchWorkVO> pageData, AnalysisLineBatchWorkDTO dto) {
        return this.baseMapper.getWorkPageList(pageData,dto);
    }

    /**
     *其他病害分析-分析批次-新增分析批次
     * @param dto
     */
    @Override
    public void saveRecord(AnalysisLineBatchSaveOrUpdateDTO dto) {
        // 主表
        AnalysisLineBatch analysisLineBatch = BeanUtil.copyProperties(dto, AnalysisLineBatch.class);
        analysisLineBatch.setId(UUIDGenerator.generate());
        analysisLineBatch.setAnalysisStatus(1); // 1-分析中


        // 明细
        List<AnalysisLineBatchCheckDataMap> analysisLineBatchCheckDataMaps = new ArrayList<>();
        List<AnalysisLineBatchSaveOrUpdateDTO.CheckDataDTO> checkDataList = dto.getCheckDataList();
        for (AnalysisLineBatchSaveOrUpdateDTO.CheckDataDTO checkDataDTO : checkDataList) {
            AnalysisLineBatchCheckDataMap analysisLineBatchCheckDataMap = new AnalysisLineBatchCheckDataMap();
            analysisLineBatchCheckDataMap.setId(UUIDGenerator.generate());
            analysisLineBatchCheckDataMap.setAnalysisBatchId(analysisLineBatch.getId());
            analysisLineBatchCheckDataMap.setAnalysisBatchCode(analysisLineBatch.getAnalysisBatchCode());
            analysisLineBatchCheckDataMap.setEkCode(checkDataDTO.getEkCode());
            analysisLineBatchCheckDataMap.setEkId(checkDataDTO.getEkId());
            analysisLineBatchCheckDataMap.setStartingMileage(checkDataDTO.getStartingMileage());
            analysisLineBatchCheckDataMap.setEndMileage(checkDataDTO.getEndMileage());
            analysisLineBatchCheckDataMap.setCheckTime(checkDataDTO.getCheckTime());
            analysisLineBatchCheckDataMap.setCheckBy(checkDataDTO.getCheckBy());
            analysisLineBatchCheckDataMap.setEkType(checkDataDTO.getEkType());
            analysisLineBatchCheckDataMap.setAnalysisStatus(1);// 分析中
            analysisLineBatchCheckDataMap.setRemark(dto.getRemark());
            analysisLineBatchCheckDataMaps.add(analysisLineBatchCheckDataMap);
        }

        this.save(analysisLineBatch);
        for (AnalysisLineBatchCheckDataMap analysisLineBatchCheckDataMap : analysisLineBatchCheckDataMaps) {
            analysisLineBatchCheckDataMapMapper.insert(analysisLineBatchCheckDataMap);
        }

        try {
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        // 执行分析
        MultiProducerLine.produce(analysisLineBatch.getId());
    }

    /**
     * 其他病害分析-分析批次-更新分析批次
     * @param dto
     */
    @Override
    public void updateRecord(AnalysisLineBatchSaveOrUpdateDTO dto) {
        // 主表
        AnalysisLineBatch analysisLineBatch = BeanUtil.copyProperties(dto, AnalysisLineBatch.class);
        analysisLineBatch.setAnalysisStatus(1); // 1-分析中

        // 明细
        // 1.先删除
        LambdaQueryWrapper<AnalysisLineBatchCheckDataMap> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(AnalysisLineBatchCheckDataMap::getAnalysisBatchId, analysisLineBatch.getId());
        analysisLineBatchCheckDataMapMapper.delete(wrapper);
        // 2.后新增
        List<AnalysisLineBatchCheckDataMap> analysisLineBatchCheckDataMaps = new ArrayList<>();
        List<AnalysisLineBatchSaveOrUpdateDTO.CheckDataDTO> checkDataList = dto.getCheckDataList();
        for (AnalysisLineBatchSaveOrUpdateDTO.CheckDataDTO checkDataDTO : checkDataList) {
            AnalysisLineBatchCheckDataMap analysisLineBatchCheckDataMap = new AnalysisLineBatchCheckDataMap();
            analysisLineBatchCheckDataMap.setId(UUIDGenerator.generate());
            analysisLineBatchCheckDataMap.setAnalysisBatchId(analysisLineBatch.getId());
            analysisLineBatchCheckDataMap.setAnalysisBatchCode(analysisLineBatch.getAnalysisBatchCode());
            analysisLineBatchCheckDataMap.setEkCode(checkDataDTO.getEkCode());
            analysisLineBatchCheckDataMap.setEkId(checkDataDTO.getEkId());
            analysisLineBatchCheckDataMap.setStartingMileage(checkDataDTO.getStartingMileage());
            analysisLineBatchCheckDataMap.setEndMileage(checkDataDTO.getEndMileage());
            analysisLineBatchCheckDataMap.setCheckTime(checkDataDTO.getCheckTime());
            analysisLineBatchCheckDataMap.setCheckBy(checkDataDTO.getCheckBy());
            analysisLineBatchCheckDataMap.setEkType(checkDataDTO.getEkType());
            analysisLineBatchCheckDataMap.setAnalysisStatus(1);// 分析中
            analysisLineBatchCheckDataMap.setRemark(dto.getRemark());
            analysisLineBatchCheckDataMaps.add(analysisLineBatchCheckDataMap);
        }

        this.updateById(analysisLineBatch);
        for (AnalysisLineBatchCheckDataMap analysisLineBatchCheckDataMap : analysisLineBatchCheckDataMaps) {
            analysisLineBatchCheckDataMapMapper.insert(analysisLineBatchCheckDataMap);
        }
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        // 执行分析
        MultiProducerLine.produce(analysisLineBatch.getId());
    }

    /**
     * 其他病害分析-分析批次-删除
     * @param idList
     */
    @Override
    @Transactional
    public void deleteBatchRecord(List<String> idList,Integer type) {
        //查询是否具备删除分析批次得条件
        List<WorkBatchDetail> list = workBatchDetailService.lambdaQuery().in(WorkBatchDetail::getAnalysisBatchId, idList).list();
        if(CollectionUtils.isNotEmpty(list)){
            throw JeecgBootException.error("删除失败,当前分析任务存在维修作业不允许删除！");
        }
        // 1.先删除病害分析主表与检查记录主表之间的关系表
        LambdaQueryWrapper<AnalysisLineBatchCheckDataMap> wrapper = Wrappers.lambdaQuery();
        wrapper.in(AnalysisLineBatchCheckDataMap::getAnalysisBatchId, idList);
        analysisLineBatchCheckDataMapMapper.delete(wrapper);
        // 2.删除单元表
        LambdaQueryWrapper<AnalysisLineBatchUnitDevice> wrapper1 = Wrappers.lambdaQuery();
        wrapper1.in(AnalysisLineBatchUnitDevice::getAnalysisBatchId, idList);
        analysisLineBatchUnitDeviceMapper.delete(wrapper1);
        //type值检查数据类型 1-道岔检查 2-钢轨常规探伤检查 3-曲线磨耗检查 4-钢轨波磨检查 5-道床检查 6-线路检查
        if(type == 1){
            //3.删除道岔单元详情表
            LambdaQueryWrapper<AnalysisLineBatchUnitDeviceTurnoutInfo> wrapper2 = Wrappers.lambdaQuery();
            wrapper2.in(AnalysisLineBatchUnitDeviceTurnoutInfo::getAnalysisBatchId, idList);
            analysisLineBatchUnitDeviceTurnoutInfoMapper.delete(wrapper2);
        }else if(type ==2){
            //3.删除钢轨常规探伤单元详情表
            LambdaQueryWrapper<AnalysisLineBatchUnitDeviceRailWearInfo> wrapper2 = Wrappers.lambdaQuery();
            wrapper2.in(AnalysisLineBatchUnitDeviceRailWearInfo::getAnalysisBatchId, idList);
            analysisLineBatchUnitDeviceRailWearInfoMapper.delete(wrapper2);
        }else if(type ==3){
            //3.删除曲线磨耗单元详情表
            LambdaQueryWrapper<AnalysisLineBatchUnitDeviceCurveWearInfo> wrapper2 = Wrappers.lambdaQuery();
            wrapper2.in(AnalysisLineBatchUnitDeviceCurveWearInfo::getAnalysisBatchId, idList);
            analysisLineBatchUnitDeviceCurveWearInfoMapper.delete(wrapper2);
        }else if(type ==4){
            //3.删除钢轨波磨单元详情表
            LambdaQueryWrapper<AnalysisLineBatchUnitDeviceCorrugationInfo> wrapper2 = Wrappers.lambdaQuery();
            wrapper2.in(AnalysisLineBatchUnitDeviceCorrugationInfo::getAnalysisBatchId, idList);
            analysisLineBatchUnitDeviceCorrugationInfoMapper.delete(wrapper2);
        }else if(type == 5){
            //3.删除道床检查单元详情表
            LambdaQueryWrapper<AnalysisLineBatchUnitDeviceTrackBedInfo> wrapper2 = Wrappers.lambdaQuery();
            wrapper2.in(AnalysisLineBatchUnitDeviceTrackBedInfo::getAnalysisBatchId, idList);
            analysisLineBatchUnitDeviceTrackBedInfoMapper.delete(wrapper2);
        }else {
            //3.删除线路检查单元详情表
            LambdaQueryWrapper<AnalysisLineBatchUnitDevicePatrolInfo> wrapper2 = Wrappers.lambdaQuery();
            wrapper2.in(AnalysisLineBatchUnitDevicePatrolInfo::getAnalysisBatchId, idList);
            analysisLineBatchUnitDevicePatrolInfoMapper.delete(wrapper2);

            LambdaQueryWrapper<AnalysisLineBatchUnitDevicePatrolAssistInfo> wrapper3 = Wrappers.lambdaQuery();
            wrapper3.in(AnalysisLineBatchUnitDevicePatrolAssistInfo::getAnalysisBatchId, idList);
            analysisLineBatchUnitDevicePatrolAssistInfoMapper.delete(wrapper3);
        }
        //4.删除分析主表
        this.baseMapper.deleteBatchIds(idList);
    }
    /**
     * 其他病害分析-分析批次-更新分析单元标记状态
     * @param id
     * @param status
     */
    @Override
    @Transactional
    public void updateRecordMarkStatus(String id, Integer status) {
        AnalysisLineBatchUnitDevice analysisLineBatchUnitDevice = new AnalysisLineBatchUnitDevice();
        analysisLineBatchUnitDevice.setId(id);
        analysisLineBatchUnitDevice.setMarkStatus(status);
        analysisLineBatchUnitDeviceMapper.updateById(analysisLineBatchUnitDevice);
    }
}
