package org.jeecg.modules.diseaseAnalysis.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 线路质量分析-分析批次表-单元设备详情（1个分析批次有多个检查批次，1个检查批次有多个单位设备，1个单元设备有多个详情）---钢轨波磨检查
 * </p>
 *
 * @author hkl
 * @since 2024-07-25
 */
@Getter
@Setter
@ApiModel(value = "AnalysisLineBatchUnitDeviceCorrugationInfo对象", description = "线路质量分析-分析批次表-单元设备详情（1个分析批次有多个检查批次，1个检查批次有多个单位设备，1个单元设备有多个详情）---钢轨波磨检查")

public class AnalysisLineBatchUnitDeviceCorrugationInfoVO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("分析批id")
    private String analysisBatchId;

    @ApiModelProperty("分析批次号")
    private String analysisBatchCode;

    @ApiModelProperty("设备检查记录主表id（t_ek_records_master_check）")
    private String ekId;

    @ApiModelProperty("检查批次号（t_ek_records_master_check）")
    private String ekCode;

    @ApiModelProperty("单元表id（t_dsa_analysis_line_batch_unit_device）")
    private String deviceId;

    @ApiModelProperty("检查设备id(设备资产四种表的主键)")
    private String deviceProjectId;

    @ApiModelProperty("检查设备编码(设备资产四种表的unit_code)")
    private String deviceProjectCode;

    @ApiModelProperty("检查设备类型（1-钢轨,2-曲线,3-竖曲线,4-道岔）")
    private Integer deviceProjectType;

    @ApiModelProperty("曲线半径")
    private BigDecimal curveRadius;

    @ApiModelProperty("曲线超高")
    private BigDecimal superHigh;

    @ApiModelProperty("曲线长度")
    private BigDecimal curveLen;

    @ApiModelProperty("检查项目-波段-谷深(10-30)")
    private BigDecimal checkBandOne;

    @ApiModelProperty("检查项目-波段-谷深(30-100)")
    private BigDecimal checkBandTwo;

    @ApiModelProperty("检查项目-波段-谷深(100-300)")
    private BigDecimal checkBandThree;

    @ApiModelProperty("检查项目-波段-谷深(300-1000)")
    private BigDecimal checkBandFour;

    @ApiModelProperty("超限记录")
    private String overrunInfo;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    private String delFlag;


}
