package org.jeecg.modules.dynamicStaticAnalysis.controller;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.modules.dynamicStaticAnalysis.entity.ConfigInstrumentCheck;
import org.jeecg.modules.dynamicStaticAnalysis.entity.ConfigLabourCheck;
import org.jeecg.modules.dynamicStaticAnalysis.entity.ConfigRailDeviceCheck;
import org.jeecg.modules.dynamicStaticAnalysis.entity.ConfigRailVehicleCheck;
import org.jeecg.modules.dynamicStaticAnalysis.service.IConfigInstrumentCheckService;
import org.springframework.web.bind.annotation.*;

import org.jeecg.common.system.base.controller.JeecgController;

import java.util.List;

/**
 * <p>
 * 动静态分析-配置-添乘仪检查超限权值 前端控制器
 * </p>
 *
 * @author hkl
 * @since 2023-08-01
 */
@RestController
@RequestMapping("/dynamicStaticAnalysis/configInstrumentCheck")
@Api(tags = "动静态分析-配置参数-添乘仪检查超限权值")
public class ConfigInstrumentCheckController extends JeecgController<ConfigInstrumentCheck, IConfigInstrumentCheckService> {

    @AutoLog(value = "动静态分析-配置参数-添乘仪检查超限权值-获取记录")
    @ApiOperation(value = "动静态分析-配置参数-添乘仪检查超限权值-获取记录", notes = "动静态分析-配置参数-添乘仪检查超限权值-获取记录")
    @GetMapping(value = "/listRecord")
    public Result<List<ConfigInstrumentCheck>> listRecord() {
        List<ConfigInstrumentCheck> records = this.service.listRecord();
        return Result.OK(records);
    }


    @AutoLog(value = "动静态分析-配置参数-添乘仪检查超限权值-更新参数")
    @ApiOperation(value = "动静态分析-配置参数-添乘仪检查超限权值-更新参数", notes = "动静态分析-配置参数-添乘仪检查超限权值-更新参数")
    @PostMapping(value = "/updateRecord")
    public Result<String> updateRecord(@RequestBody ConfigInstrumentCheck record) {

        this.service.updateById(record);

        return Result.OK("操作成功");
    }
}
