package org.jeecg.modules.dynamicStaticAnalysis.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 动静态分析-分析批次-单元设备
 * </p>
 *
 * @author hkl
 * @since 2023-08-03
 */
@Data
@ApiModel(value = "AnalysisBatchUnitDeviceDTO对象", description = "动静态分析-分析批次-单元设备")
public class AnalysisBatchUnitDeviceDTO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "当前页码")
    private Integer pageNo = 1;

    @ApiModelProperty(value = "每页记录数")
    private Integer pageSize = 10;

    @ApiModelProperty("分析批id")
    private String analysisBatchId;

    @ApiModelProperty("设备单元起始里程")
    private BigDecimal unitStartingMileage;

    @ApiModelProperty("设备单元结束里程")
    private BigDecimal unitEndMileage;

    @ApiModelProperty("是否超限 0-不超限 1-超限")
    private Integer isTransfinite;

    @ApiModelProperty("单元编号")
    private String unitCode;

    @ApiModelProperty("设备编号")
    private String unitDeviceCode;

    @ApiModelProperty("派工状态 0-未派工 1-已派工")
    private Integer workStatus;

    @ApiModelProperty("得分平级 0-无 1-优良 2-合格 3-失格")
    private List<String> gradeJudgeList;

    @ApiModelProperty("设备单元类型1-钢轨 2-曲线 3-竖曲线 4-道岔")
    private List<Integer> unitTypeList;
}
