package org.jeecg.modules.dynamicStaticAnalysis.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(value = "CheckBatchVO对象", description = "动静态分析-检查批次VO")
public class CheckBatchDTO {

    @ApiModelProperty("检查批次编号")
    private String ekCode;

    @ApiModelProperty("检查类型")
    private Integer ekType;

    @ApiModelProperty("所属线路id")
    private String lightRailId;

    @ApiModelProperty("所属线别id")
    private String lineAliasId;

    @ApiModelProperty("起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty("终点里程")
    private BigDecimal endMileage;

    @ApiModelProperty("检查日期开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startTime;

    @ApiModelProperty("检查日期截止日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endTime;

    @ApiModelProperty("备注")
    private String remark;
}
