package org.jeecg.modules.dynamicStaticAnalysis.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 动静态分析-轨检车-tqi单元总结报告和单元映射关联关系
 * </p>
 *
 * @author hkl
 * @since 2023-11-30
 */
@Getter
@Setter
@TableName("t_dsa_analysis_tqi_report_check_unit_device_map")
@ApiModel(value = "AnalysisTqiReportCheckUnitDeviceMap对象", description = "动静态分析-轨检车-tqi单元总结报告和单元映射关联关系")
public class AnalysisTqiReportCheckUnitDeviceMap implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("分析批次单元设备id")
    @TableField("analysis_batch_unit_device_id")
    private String analysisBatchUnitDeviceId;

    @ApiModelProperty("分析批次号")
    @TableField("analysis_batch_code")
    private String analysisBatchCode;

    @ApiModelProperty("分析批id")
    @TableField("analysis_batch_id")
    private String analysisBatchId;

    @ApiModelProperty("检查主表id")
    @TableField("check_id")
    private String checkId;

    @ApiModelProperty("检查数据类型 1-人工静态检查 2-轨检仪静态检查 3-轨检车检查 4-添乘仪检查")
    @TableField("check_type")
    private Integer checkType;

    @ApiModelProperty("单元id")
    @TableField("unit_id")
    private String unitId;

    @ApiModelProperty("单元code")
    @TableField("unit_code")
    private String unitCode;

    @ApiModelProperty("设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔")
    @TableField("unit_type")
    private Integer unitType;

    @ApiModelProperty("设备单元名称")
    @TableField("unit_type_name")
    private String unitTypeName;

    @ApiModelProperty("设备单元开始里程")
    @TableField("unit_starting_mileage")
    private BigDecimal unitStartingMileage;

    @ApiModelProperty("设备单元中心里程")
    @TableField("unit_center_mileage")
    private BigDecimal unitCenterMileage;

    @ApiModelProperty("设备单元结束里程")
    @TableField("unit_end_mileage")
    private BigDecimal unitEndMileage;

    @ApiModelProperty("tqi报告id")
    @TableField("tqi_report_id")
    private String tqiReportId;

    @ApiModelProperty("开始里程(m)")
    @TableField("start_mileage")
    private BigDecimal startMileage;

    @ApiModelProperty("终点里程(m)")
    @TableField("end_mileage")
    private BigDecimal endMileage;

    @ApiModelProperty("区间名称")
    @TableField("section_name")
    private String sectionName;

    @ApiModelProperty("高低左")
    @TableField("high_low_left")
    private String highLowLeft;

    @ApiModelProperty("高低右")
    @TableField("high_low_right")
    private String highLowRight;

    @ApiModelProperty("轨向左")
    @TableField("track_left")
    private String trackLeft;

    @ApiModelProperty("轨向右")
    @TableField("track_right")
    private String trackRight;

    @ApiModelProperty("水平（mm）")
    @TableField("level")
    private String level;

    @ApiModelProperty("轨距（mm）")
    @TableField("track_gauge")
    private String trackGauge;

    @ApiModelProperty("三角坑（mm）")
    @TableField("triangular_pit")
    private String triangularPit;

    @ApiModelProperty("TQI数值")
    @TableField("tqi_come_upon")
    private String tqiComeUpon;

    @ApiModelProperty("TQI超标")
    @TableField("tqi_above_standard")
    private String tqiAboveStandard;

    @ApiModelProperty("扣分")
    @TableField("deduct")
    private String deduct;

    @ApiModelProperty("检测标准")
    @TableField("standard")
    private String standard;

    @ApiModelProperty("速度（km/h）")
    @TableField("spend")
    private String spend;


}
