package org.jeecg.modules.dynamicStaticAnalysis.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 动静态分析-参数配置-容许值差
 * </p>
 *
 * @author hkl
 * @since 2023-08-03
 */
@Getter
@Setter
@TableName("t_dsa_config_allow_value")
@ApiModel(value = "ConfigAllowValue对象", description = "动静态分析-参数配置-容许值差")
public class ConfigAllowValue implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("大轨距(mm)")
    @TableField("big_track_gauge")
    private Integer bigTrackGauge;

    @ApiModelProperty("小轨距(mm)")
    @TableField("small_track_gauge")
    private Integer smallTrackGauge;

    @ApiModelProperty("水平(mm)")
    @TableField("level")
    private Integer level;

    @ApiModelProperty("三角坑(mm)")
    @TableField("triangular_pit")
    private Integer triangularPit;

    @ApiModelProperty("轨向(mm)")
    @TableField("direction")
    private Integer direction;

    @ApiModelProperty("高低(mm)")
    @TableField("height")
    private Integer height;

    @ApiModelProperty("垂直加速度(g)")
    @TableField("vertical_acceleration")
    private Integer verticalAcceleration;

    @ApiModelProperty("横向加速度(g)")
    @TableField("lateral_acceleration")
    private Integer lateralAcceleration;

    @ApiModelProperty("规矩变化率")
    @TableField("track_gauge_change")
    private Integer trackGaugeChange;

    @ApiModelProperty("曲率变化率")
    @TableField("curvature_change")
    private Integer curvatureChange;

    @ApiModelProperty("是否派工 0-否 1-是(默认值)")
    @TableField("is_work")
    private Integer isWork;

    @ApiModelProperty("是否启用 0-否 1-启用(默认值)")
    @TableField("is_enable")
    private Integer isEnable;


}
