package org.jeecg.modules.dynamicStaticAnalysis.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 动静态分析-配置-人工检查超限权值
 * </p>
 *
 * @author hkl
 * @since 2023-08-01
 */
@Getter
@Setter
@TableName("t_dsa_config_labour_check")
@ApiModel(value = "ConfigLabourCheck对象", description = "动静态分析-配置-人工检查超限权值")
public class ConfigLabourCheck implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("数据字典值")
    @TableField("dict_value")
    private String dictValue;

    @ApiModelProperty("数据字典标签")
    @TableField("dict_label")
    private String dictLabel;

    @ApiModelProperty("速度下限")
    @TableField("speed_min")
    private Integer speedMin;

    @ApiModelProperty("速度上限")
    @TableField("speed_max")
    private Integer speedMax;

    @ApiModelProperty("钢轨")
    @TableField("rail")
    private String rail;

    @ApiModelProperty("曲线")
    @TableField("curve")
    private String curve;

    @ApiModelProperty("竖曲线")
    @TableField("vertical_curve")
    private String verticalCurve;

    @ApiModelProperty("道岔")
    @TableField("rail_switch")
    private String railSwitch;

    @ApiModelProperty("是否删除（0：未删除； 1：已删除）")
    @TableField("del_flag")
    private String delFlag;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;


}
