package org.jeecg.modules.dynamicStaticAnalysis.face.impl;

import org.jeecg.modules.dynamicStaticAnalysis.face.AnalysisBatchUnitDeviceFace;
import org.jeecg.modules.dynamicStaticAnalysis.service.IAnalysisBatchUnitDeviceService;
import org.jeecg.modules.unitDevice.vo.*;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
public class AnalysisBatchUnitDeviceFaceImpl implements AnalysisBatchUnitDeviceFace {

    @Resource
    private IAnalysisBatchUnitDeviceService analysisBatchUnitDeviceService;


    @Override
    public CaseReportCheckDataDetailVO checkData(String id) {
        CaseReportCheckDataDetailVO vo = new CaseReportCheckDataDetailVO();
        // 静态数据
//        List<StaticCheckVO> staticCheckVOS = analysisBatchUnitDeviceService.getUnitDeviceStaticData(id);
//        for (StaticCheckVO staticCheckVO : staticCheckVOS) {
//            if (staticCheckVO.getCheckType() == 1) {
//                labourCheckVOList.add(staticCheckVO);
//            } else {
//                railDeviceCheckVOList.add(staticCheckVO);
//            }
//        }

        // 人工检查
        List<StaticCheckVO> labourCheckVOList = analysisBatchUnitDeviceService.getLabourCheck(id);
        vo.setLabourCheckVOList(labourCheckVOList);

        // 轨检仪
        List<StaticCheckVO> railDeviceCheckVOList = analysisBatchUnitDeviceService.getRailDeviceCheck(id);
        vo.setRailDeviceCheckVOList(railDeviceCheckVOList);


        // 轨检车数据
        List<RailVehicleCheckVO> railVehicleCheckVOList = analysisBatchUnitDeviceService.getUnitDeviceOverReport(id);
        vo.setRailVehicleCheckVOList(railVehicleCheckVOList);

        List<RailVehicleTqiVO> railVehicleTqiVOList = analysisBatchUnitDeviceService.getUnitDeviceTqi(id);
        vo.setRailVehicleTqiVOList(railVehicleTqiVOList);


        // 添乘以
        List<RailAddInstrumentCheckVO> railAddInstrumentCheckVOList = analysisBatchUnitDeviceService.getUnitDeviceAdditiveInfo(id);
        vo.setRailAddInstrumentCheckVOList(railAddInstrumentCheckVOList);

        return vo;
    }
}
