package org.jeecg.modules.dynamicStaticAnalysis.entity;

    import com.baomidou.mybatisplus.annotation.TableField;
    import com.baomidou.mybatisplus.annotation.TableId;
    import com.baomidou.mybatisplus.annotation.TableName;
    import java.io.Serializable;
    import java.math.BigDecimal;
    import java.util.Date;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import lombok.Getter;
    import lombok.Setter;

/**
* <p>
    * 动静态几何尺寸对应的添乘仪详情表
    * </p>
*
* @author hkl
* @since 2023-11-30
*/
    @Getter
    @Setter
    @ApiModel(value = "AnalysisAdditiveCheckUnitDeviceMap对象", description = "动静态几何尺寸对应的添乘仪详情表")

public class AnalysisAdditiveCheckUnitDeviceMapDTO {


    private static final long serialVersionUID = 1L;

            @ApiModelProperty("主键")
    private String id;

            @ApiModelProperty("创建人")
    private String createBy;

            @ApiModelProperty("创建日期")
    private Date createTime;

            @ApiModelProperty("更新人")
    private String updateBy;

            @ApiModelProperty("更新时间")
    private Date updateTime;

            @ApiModelProperty("分析批次id")
    private String analysisBatchId;

            @ApiModelProperty("分析批次code")
    private String analysisBatchCode;

            @ApiModelProperty("分析批次单元设备id")
    private String analysisBatchUnitDeviceId;

            @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    private String movementMasterId;

            @ApiModelProperty("设备单元id")
    private String unitId;

            @ApiModelProperty("设备单元编码")
    private String unitCode;

            @ApiModelProperty("设备单元编码")
    private String unitDeviceCode;

            @ApiModelProperty("设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔")
    private Integer unitType;

            @ApiModelProperty("设备单元类型名称")
    private String unitTypeName;

            @ApiModelProperty("设备单元起始里程")
    private BigDecimal unitStartMileage;

            @ApiModelProperty("设备单元中心里程")
    private BigDecimal unitCenterMileage;

            @ApiModelProperty("设备单元终点里程")
    private BigDecimal unitEndMileage;

            @ApiModelProperty("测点里程")
    private BigDecimal pointMileage;

            @ApiModelProperty("水平加速度")
    private BigDecimal zontalSpeed;

            @ApiModelProperty("水平加速度等级")
    private Integer zontalSpeedLevel;

            @ApiModelProperty("垂直加速度")
    private BigDecimal verticalSpeed;

            @ApiModelProperty("垂直加速度等级")
    private Integer verticalSpeedLevel;

            @ApiModelProperty("速度")
    private BigDecimal speed;

            @ApiModelProperty("手动标记")
    private String mark;

            @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    private String delFlag;

            @ApiModelProperty("排序字段")
    private Integer infoSort;


}
