package org.jeecg.modules.dynamicStaticAnalysis.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.jeecg.modules.dynamicStaticAnalysis.dto.AnalysisBatchUnitDeviceDTO;
import org.jeecg.modules.dynamicStaticAnalysis.entity.AnalysisBatchUnitDevice;
import org.jeecg.modules.dynamicStaticAnalysis.mapper.AnalysisBatchUnitDeviceMapper;
import org.jeecg.modules.dynamicStaticAnalysis.mapper.AnalysisBatchUnitDeviceTransfiniteMapper;
import org.jeecg.modules.dynamicStaticAnalysis.service.IAnalysisBatchUnitDeviceService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.modules.dynamicStaticAnalysis.vo.AnalysisBatchUnitDeviceTransfiniteVO;
import org.jeecg.modules.dynamicStaticAnalysis.vo.AnalysisBatchUnitDeviceVO;
import org.jeecg.modules.unitDevice.vo.RailAddInstrumentCheckVO;
import org.jeecg.modules.unitDevice.vo.RailVehicleCheckVO;
import org.jeecg.modules.unitDevice.vo.RailVehicleTqiVO;
import org.jeecg.modules.unitDevice.vo.StaticCheckVO;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 动静态分析-分析批次-单元设备 服务实现类
 * </p>
 *
 * @author hkl
 * @since 2023-08-03
 */
@Service
public class AnalysisBatchUnitDeviceServiceImpl extends ServiceImpl<AnalysisBatchUnitDeviceMapper, AnalysisBatchUnitDevice> implements IAnalysisBatchUnitDeviceService {
    @Resource
    private AnalysisBatchUnitDeviceTransfiniteMapper transfiniteMapper;


    @Override
    public Page<AnalysisBatchUnitDeviceVO> listRecord(Page<AnalysisBatchUnitDeviceVO> pageData, AnalysisBatchUnitDeviceDTO dto) {

        Page<AnalysisBatchUnitDeviceVO> page = this.baseMapper.pageRecord(pageData, dto);

        if (ObjectUtil.isNotEmpty(page.getRecords())) {
            List<String> analysisBatchUnitDeviceIds = page.getRecords().stream().map(AnalysisBatchUnitDeviceVO::getId).collect(Collectors.toList());
            List<AnalysisBatchUnitDeviceTransfiniteVO> transfiniteListAll = transfiniteMapper.getTransfiniteListByIds(analysisBatchUnitDeviceIds);
            Map<String, List<AnalysisBatchUnitDeviceTransfiniteVO>> map = transfiniteListAll.stream().collect(Collectors.groupingBy(AnalysisBatchUnitDeviceTransfiniteVO::getAnalysisBatchUnitDeviceId));
            page.getRecords().forEach(record -> {
                List<AnalysisBatchUnitDeviceTransfiniteVO> transfiniteList = map.get(record.getId());
                if (transfiniteList == null) {
                    transfiniteList = new ArrayList<>();
                }
                record.setTransfiniteList(transfiniteList);
            });

        }

        return page;
    }


    @Override
    public List<StaticCheckVO> getUnitDeviceStaticData(String id) {
        return this.baseMapper.getUnitDeviceStaticData(id);
    }

    @Override
    public List<RailVehicleCheckVO> getUnitDeviceOverReport(String id) {
        return this.baseMapper.getUnitDeviceOverReport(id);
    }

    @Override
    public List<RailVehicleTqiVO> getUnitDeviceTqi(String id) {
        return this.baseMapper.getUnitDeviceTqi(id);
    }

    @Override
    public List<RailAddInstrumentCheckVO> getUnitDeviceAdditiveInfo(String id) {
        return this.baseMapper.getUnitDeviceAdditiveInfo(id);
    }

    @Override
    public List<StaticCheckVO> getLabourCheck(String id) {
        return this.baseMapper.getLabourCheck(id);
    }

    @Override
    public List<StaticCheckVO> getRailDeviceCheck(String id) {
        return this.baseMapper.getRailDeviceCheck(id);
    }
}
