package org.jeecg.modules.iam.controller;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.modules.iam.service.IamService;
import org.jeecg.modules.iam.vo.IamLoginUserVO;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <p>
 * 统一身份认证
 * </p>
 *
 * @author hkl
 * @since 2024-06-19 16:02:40
 */
@RestController
@RequestMapping("/iam/")
@Api(tags = "统一身份集成")
@Slf4j
public class IamController {

    @Value("${iam.getUserInfoSucceed}")
    private String getUserInfoSucceed;

    @Resource
    private IamService iamService;


    @AutoLog(value = "统一身份集成-通过tempCode获取用户身份信息")
    @ApiOperation(value = "统一身份集成-通过tempCode获取用户身份信息", notes = "统一身份集成-通过tempCode获取用户身份信息")
    @PostMapping(value = "/login/{tempCode}")
    public Result<IamLoginUserVO> login(@PathVariable String tempCode) {
        log.info("==================当前登录tempCode:" + tempCode);

        IamLoginUserVO vo = iamService.login(tempCode);

        log.info("==================当前登录vo:" + JSONObject.toJSONString(vo));
        if (getUserInfoSucceed.equals(vo.getStatus())) {
            return Result.OK(vo);
        } else {
            return Result.error(HttpStatus.UNAUTHORIZED.value(), vo.getMessage());
        }
    }

}
