package org.jeecg.modules.maintenanceWork.controller;


import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.modules.diseaseAnalysis.entity.AnalysisLineBatchUnitDevicePatrolAssistInfo;
import org.jeecg.modules.diseaseAnalysis.service.IAnalysisLineBatchUnitDevicePatrolAssistInfoService;
import org.jeecg.modules.diseaseAnalysis.service.IAnalysisLineBatchUnitDeviceService;
import org.jeecg.modules.diseaseAnalysis.vo.*;
import org.jeecg.modules.dynamicStaticAnalysis.entity.AnalysisBatch;
import org.jeecg.modules.dynamicStaticAnalysis.vo.AnalysisBatchUnitDeviceTransfiniteVO;
import org.jeecg.modules.maintenanceWork.dto.*;
import org.jeecg.modules.maintenanceWork.entity.WorkBatch;
import org.jeecg.modules.maintenanceWork.entity.WorkBatchDetail;
import org.jeecg.modules.maintenanceWork.service.IWorkBatchService;
import org.jeecg.modules.maintenanceWork.vo.*;
import org.jeecg.modules.maintenanceWork.service.IWorkBatchDetailService;
import org.jeecg.modules.maintenanceWork.service.IWorkBatchDetailModifyService;
import org.springframework.web.bind.annotation.*;

import org.jeecg.common.system.base.controller.JeecgController;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 维修作业管理-作业计划批次管理表 前端控制器
 * </p>
 *
 * @author hkl
 * @since 2023-08-09
 */
@RestController
@RequestMapping("/maintenanceWork/workBatch")
@Api(tags = "维修作业管理-作业计划批次管理")
public class WorkBatchController extends JeecgController<WorkBatch, IWorkBatchService> {

    @Resource
    private IWorkBatchDetailService workBatchDetailService;

    @Resource
    private IWorkBatchDetailModifyService workBatchDetailModifyService;

    @Resource
    private IAnalysisLineBatchUnitDeviceService analysisLineBatchUnitDeviceService;


    @AutoLog(value = "维修作业管理-作业计划批次管理-分页列表查询")
    @ApiOperation(value = "维修作业管理-作业计划批次管理-分页列表查询", notes = "维修作业管理-作业计划批次管理-分页列表查询")
    @GetMapping(value = "/listRecord")
    public Result<IPage<WorkBatchVO>> listRecord(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                 @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                 WorkBatchDTO dto) {
        Page<WorkBatchVO> pageData = new Page<>(pageNo, pageSize);
        pageData = this.service.listRecord(pageData, dto);
        return Result.OK(pageData);
    }

    @AutoLog(value = "维修作业管理-作业计划批次管理-获取详情关联超限数据")
    @ApiOperation(value = "维修作业管理-作业计划批次管理-获取详情关联超限数据", notes = "维修作业管理-作业计划批次管理-获取详情关联超限数据")
    @GetMapping(value = "/getTransfiniteList")
    public Result<Map<String, Object>> getTransfiniteList(@RequestParam("analysisBatchId") String analysisBatchId, @RequestParam("analysisBatchUnitDeviceId") String analysisBatchUnitDeviceId, @RequestParam("analysisType") Integer analysisType) {
        Map<String, Object> map = new HashMap<>();
        if (analysisType == 0) {
            List<AnalysisBatchUnitDeviceTransfiniteVO> list = this.service.getTransfiniteList(analysisBatchUnitDeviceId);
            //动静态超限数据
            map.put("cx", list);
        }else if(analysisType == 1){
            List<AnalysisLineBatchUnitDeviceTurnoutInfoVO> turnoutInfoVOList = this.service.getAnalysisLineBatchUnitEkInfoList(analysisBatchId,analysisBatchUnitDeviceId);
            //道岔超限数据
            map.put("cx", turnoutInfoVOList);
        }else if(analysisType == 2){
            List<AnalysisLineBatchUnitDeviceRailWearInfoVO> railWearInfoList = this.service.getAnalysisLineBatchUnitDeviceRailWearInfoList(analysisBatchId,analysisBatchUnitDeviceId);
            //钢轨伤损超限数据
            map.put("cx", railWearInfoList);
        }else if(analysisType == 3){
            List<AnalysisLineBatchUnitDeviceCurveWearInfoVO> curveWearInfoList = this.service.getAnalysisLineBatchUnitDeviceCurveWearInfoList(analysisBatchId,analysisBatchUnitDeviceId);
            //曲线磨耗检查超限数据
            map.put("cx", curveWearInfoList);
        }else if(analysisType == 4){
            List<AnalysisLineBatchUnitDeviceCorrugationInfoVO> corrugationInfoList = this.service.getAnalysisLineBatchUnitDeviceCorrugationInfoList(analysisBatchId,analysisBatchUnitDeviceId);
            //钢轨波磨检查超限数据
            map.put("cx", corrugationInfoList);
        }else if(analysisType == 5){
            List<AnalysisLineBatchUnitDeviceTrackBedInfoVO> trackBedInfoList = this.service.getAnalysisLineBatchUnitDeviceTrackBedInfoList(analysisBatchId,analysisBatchUnitDeviceId);
            Map<String, List<AnalysisLineBatchUnitDeviceTrackBedInfoVO>> trackBedMap = trackBedInfoList.stream().collect(Collectors.groupingBy(AnalysisLineBatchUnitDeviceTrackBedInfoVO::getTrackBedCode));
            //道床检查超限数据
            map.put("cx", trackBedMap);
        }else {
            //根据分析单元id查询巡道员备忘录
            String remark = analysisLineBatchUnitDeviceService.getById(analysisBatchUnitDeviceId).getRemark();
            List<AnalysisLineBatchUnitDevicePatrolInfoVO> patrolInfoList = this.service.getAnalysisLineBatchUnitDevicePatrolInfoList(analysisBatchId,analysisBatchUnitDeviceId);
            List<AnalysisLineBatchUnitDevicePatrolAssistInfoVO> patrolAssistInfoList = this.service.getAnalysisLineBatchUnitDevicePatrolAssistInfoList(analysisBatchId,analysisBatchUnitDeviceId);
            //线路巡查超限数据
            map.put("cx", patrolInfoList);
            //协助线路巡查超限数据
            map.put("xlcx", patrolAssistInfoList);
            //巡道员备忘录
            map.put("remark", remark);
        }
        return Result.OK(map);
    }
    @AutoLog(value = "维修作业管理-作业计划批次管理-获取整改详情数据")
    @ApiOperation(value = "维修作业管理-作业计划批次管理-获取整改详情数据", notes = "维修作业管理-作业计划批次管理-获取整改详情数据")
    @GetMapping(value = "/getRectificationList")
    public Result<Map<String, Object>> getRectificationList(@RequestParam("workId") String workId, @RequestParam("workInfoId") String workInfoId, @RequestParam("analysisType") Integer analysisType) {
        Map<String, Object> map = new HashMap<>();
        if(analysisType == 1){
            List<WorkBatchDetailTurnoutInfoVO> turnoutInfoVOList = this.service.getWorkBatchDetailTurnoutInfoList(workId,workInfoId);
            //整改道岔超限数据
            map.put("zg", turnoutInfoVOList);
        }else if(analysisType == 2){
            List<WorkBatchDetailRailWearInfoVO> railWearInfoList = this.service.getWorkBatchDetailRailWearInfoList(workId,workInfoId);
            //整改钢轨伤损超限数据
            map.put("zg", railWearInfoList);
        }else if(analysisType == 3){
            List<WorkBatchDetailCurveWearInfoVO> curveWearInfoList = this.service.getWorkBatchDetailCurveWearInfoList(workId,workInfoId);
            //整改曲线磨耗检查超限数据
            map.put("zg", curveWearInfoList);
        }else if(analysisType == 4){
            List<WorkBatchDetailCorrugationInfoVO> corrugationInfoList = this.service.getWorkBatchDetailCorrugationInfoList(workId,workInfoId);
            //整改钢轨波磨检查超限数据
            map.put("zg", corrugationInfoList);
        }else if(analysisType == 5){
            List<WorkBatchDetailTrackBedInfoVO> trackBedInfoList = this.service.getWorkBatchDetailTrackBedInfoList(workId,workInfoId);
            Map<String, List<WorkBatchDetailTrackBedInfoVO>> trackBedMap = trackBedInfoList.stream().collect(Collectors.groupingBy(WorkBatchDetailTrackBedInfoVO::getTrackBedCode));
            //整改道床检查超限数据
            map.put("zg", trackBedMap);
        }else {
            List<WorkBatchDetailPatrolInfoVO> patrolInfoList = this.service.getWorkBatchDetailPatrolInfoList(workId,workInfoId);
            List<WorkBatchDetailPatrolAssistInfoVO> patrolAssistInfoList = this.service.getWorkBatchDetailPatrolAssistInfoList(workId,workInfoId);
            //整改线路巡查超限数据
            map.put("zg", patrolInfoList);
            //整改协助线路巡查超限数据
            map.put("xzzg", patrolAssistInfoList);
        }
        return Result.OK(map);
    }

    @AutoLog(value = "维修作业管理-作业计划批次管理-获取派工用户")
    @ApiOperation(value = "维修作业管理-作业计划批次管理-获取派工用户", notes = "维修作业管理-作业计划批次管理-获取派工用户")
    @GetMapping(value = "/listUser")
    @ApiParam(name = "query", value = "查询名称/账号", required = true)
    public Result<List<WorkBatchUserVO>> listUser(String query) {

        List<WorkBatchUserVO> userList = this.service.listUser(query);

        return Result.OK(userList);
    }


    @AutoLog(value = "维修作业管理-作业计划批次管理-维修作业管理页面新增")
    @ApiOperation(value = "维修作业管理-作业计划批次管理-维修作业管理页面新增", notes = "维修作业管理-作业计划批次管理-维修作业管理页面新增")
    @PostMapping(value = "/saveRecord")
    public Result<String> saveRecord(@RequestBody WorkBatchSaveOrUpdateDTO dto) {
        // 去重
        WorkBatch exist = this.service.lambdaQuery()
                .eq(WorkBatch::getWorkBatchCode, dto.getWorkBatchCode())
                .ne(ObjectUtil.isNotEmpty(dto.getId()), WorkBatch::getId, dto.getId())
                .last("limit 1")
                .one();
        if (exist != null) {
            throw new JeecgBootException("【" + dto.getWorkBatchCode() + "】作业批次已存在");
        }

        this.service.saveRecord(dto);

        return Result.OK("操作成功");
    }


    @AutoLog(value = "维修作业管理-作业计划批次管理-超限页面新增")
    @ApiOperation(value = "维修作业管理-作业计划批次管理-超限页面新增", notes = "维修作业管理-作业计划批次管理-超限页面新增")
    @PostMapping(value = "/transfiniteSaveRecord")
    public Result<String> transfiniteSaveRecord(@RequestBody WorkBatchTransfiniteSaveDTO dto) {
        WorkBatch exist = this.service.lambdaQuery()
                .eq(WorkBatch::getWorkBatchCode, dto.getWorkBatchCode())
                .last("limit 1")
                .one();
        if (exist != null) {
            throw new JeecgBootException("【" + dto.getWorkBatchCode() + "】作业批次已存在");
        }
        this.service.transfiniteSaveRecord(dto);

        return Result.OK("操作成功");
    }

    @AutoLog(value = "维修作业管理-作业计划批次管理-超限页面新增")
    @ApiOperation(value = "维修作业管理-作业计划批次管理-超限页面新增", notes = "维修作业管理-作业计划批次管理-超限页面新增")
    @PostMapping(value = "/batchSaveRecord")
    public Result<String> batchSaveRecord(@RequestBody AnalysisBatchSaveDTO dto) {
        WorkBatch exist = this.service.lambdaQuery()
                .eq(WorkBatch::getWorkBatchCode, dto.getWorkBatchCode())
                .last("limit 1")
                .one();
        if (exist != null) {
            throw new JeecgBootException("【" + dto.getWorkBatchCode() + "】作业批次已存在");
        }

        this.service.batchSaveRecord(dto);

        return Result.OK("操作成功");
    }


    @AutoLog(value = "维修作业管理-作业计划批次管理-通过id删除")
    @ApiOperation(value = "维修作业管理-作业计划批次管理-通过id删除", notes = "维修作业管理-作业计划批次管理-通过id删除")
    @GetMapping(value = "/deleteRecord")
    public Result<String> deleteRecord(@RequestParam(name = "id", required = true) String id) {
        this.service.deleteRecord(id);

        return Result.OK("删除成功!");
    }

    @AutoLog(value = "维修作业管理-作业计划批次管理-获取里程单元设备")
    @ApiOperation(value = "维修作业管理-作业计划批次管理-获取里程单元设备", notes = "维修作业管理-作业计划批次管理-获取里程单元设备")
    @PostMapping(value = "/getUnitDeviceList")
    public Result<Page<Map<String, Object>>> getUnitDevicePage(@RequestBody UnitDeviceDTO dto) {
        Page<Map<String, Object>> pageData = new Page<>(dto.getPageNo(), dto.getPageSize());
        pageData = this.service.getUnitDevicePage(pageData, dto);
        return Result.OK(pageData);
    }


    @AutoLog(value = "维修作业管理-作业计划批次管理-获取整改")
    @ApiOperation(value = "维修作业管理-作业计划批次管理-获取整改", notes = "维修作业-维修作业批列表-获取设备列表")
    @GetMapping(value = "/getUnitDeviceModify")
    public Result<WorkUnitDeviceModifyVO> getUnitDeviceModify(String workBatchDetailId) {

        WorkBatchDetail workBatchDetail = workBatchDetailService.getById(workBatchDetailId);
        WorkUnitDeviceModifyVO vo = new WorkUnitDeviceModifyVO();
        vo.setWorkBatchDetailId(workBatchDetail.getId());

        if (ObjectUtil.isNotEmpty(workBatchDetail)) {
            List<WorkBatchDetailModifyVO> detailList = workBatchDetailModifyService.getUnitDeviceModify(workBatchDetailId);
            vo.setDetailList(detailList);
        }
        return Result.ok(vo);
    }


}
