package org.jeecg.modules.maintenanceWork.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 维修作业管理-作业计划批次管理明细表
 * </p>
 *
 * @author hkl
 * @since 2023-08-09
 */
@Data
@ApiModel(value = "DispatchDTO对象", description = "维修作业管理-超限")
public class DispatchDTO {

    @ApiModelProperty("分析批次单元设备id")
    private String id;

    @ApiModelProperty("分析批次号")
    private String analysisBatchCode;

    @ApiModelProperty("分析批id")
    private String analysisBatchId;

    @ApiModelProperty("检查批次id")
    private String ekId;

    @ApiModelProperty("检查批次code")
    private String ekCode;

    @ApiModelProperty("单元设备id")
    private String unitId;

    @ApiModelProperty("单元设备code")
    private String unitCode;

    @ApiModelProperty("设备单元类型1-钢轨 2-曲线 3-竖曲线 4-道岔")
    private Integer unitType;

    @ApiModelProperty("设备单元类型名称")
    private String unitTypeName;

    @ApiModelProperty("设备编号")
    private String unitDeviceCode;

    @ApiModelProperty("设备单元起始里程")
    private BigDecimal unitStartingMileage;

    @ApiModelProperty("设备单元中心里程")
    private BigDecimal unitCenterMileage;

    @ApiModelProperty("设备单元结束里程")
    private BigDecimal unitEndMileage;

    @ApiModelProperty("单元得分等级中文")
    private String unitScoreLevelStr;

    @ApiModelProperty("单元得分等级 1-优良 2-合格 3-失格")
    private int unitScoreLevel;

    @ApiModelProperty("单元得分")
    private BigDecimal unitScore;

    @ApiModelProperty("检查日期")
    private Date checkTime;

    @ApiModelProperty("检查人")
    private String checkBy;
}
