package org.jeecg.modules.maintenanceWork.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 维修作业管理-作业计划批次管理明细表
 * </p>
 *
 * @author hkl
 * @since 2023-08-09
 */
@Getter
@Setter
@TableName("t_mw_work_batch_detail")
@ApiModel(value = "WorkBatchDetail对象", description = "维修作业管理-作业计划批次管理明细表")
public class WorkBatchDetail implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("工作批次code")
    @TableField("work_batch_code")
    private String workBatchCode;

    @ApiModelProperty("工作批次id")
    @TableField("work_batch_id")
    private String workBatchId;

    @TableField("analysis_batch_id")
    @ApiModelProperty("分析批次id")
    private String analysisBatchId;

    @TableField("analysis_batch_code")
    @ApiModelProperty("分析批次code")
    private String analysisBatchCode;

    @ApiModelProperty("分析批次单元设备id")
    @TableField("analysis_batch_unit_device_id")
    private String analysisBatchUnitDeviceId;

    @TableField("ek_id")
    @ApiModelProperty("检查批次id")
    private String ekId;

    @ApiModelProperty("检查批次code")
    @TableField("ek_code")
    private String ekCode;

    @ApiModelProperty("检查日期")
    @TableField("check_time")
    private Date checkTime;

    @ApiModelProperty("检查人")
    @TableField("check_by")
    private String checkBy;

    @ApiModelProperty("单元设备id")
    @TableField("unit_id")
    private String unitId;

    @ApiModelProperty("单元设备code")
    @TableField("unit_code")
    private String unitCode;

    @ApiModelProperty("设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔")
    @TableField("unit_type")
    private Integer unitType;

    @ApiModelProperty("设备单元类型名称")
    @TableField("unit_type_name")
    private String unitTypeName;

    @ApiModelProperty("设备编号")
    @TableField("unit_device_code")
    private String unitDeviceCode;

    @ApiModelProperty("设备单元起始里程")
    @TableField("unit_start_mileage")
    private BigDecimal unitStartMileage;

    @ApiModelProperty("设备单元中心里程")
    @TableField("unit_center_mileage")
    private BigDecimal unitCenterMileage;

    @ApiModelProperty("设备单元结束里程")
    @TableField("unit_end_mileage")
    private BigDecimal unitEndMileage;

    @ApiModelProperty("单元得分等级 1-优良 2-合格 3-失格")
    @TableField("unit_score_level")
    private Integer unitScoreLevel;

    @ApiModelProperty("单元得分等级说明")
    @TableField("unit_score_level_str")
    private String unitScoreLevelStr;

    @ApiModelProperty("单元得分")
    @TableField("unit_score")
    private BigDecimal unitScore;

    @ApiModelProperty("作业状态 0-未作业 9-已作业")
    @TableField("work_status")
    private Integer workStatus;

    @ApiModelProperty("整改备注")
    @TableField("reform_remark")
    private String reformRemark;

    @ApiModelProperty("维修日期")
    @TableField("maintenance_date")
    private Date maintenanceDate;

    @ApiModelProperty("维修建议")
    @TableField("remark")
    private String remark;


}
