package org.jeecg.modules.maintenanceWork.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 维修作业---钢轨波磨检查
 * </p>
 *
 * @author hkl
 * @since 2024-08-05
 */
@Getter
@Setter
@TableName("t_mw_work_batch_detail_corrugation_info")
@ApiModel(value = "WorkBatchDetailCorrugationInfo对象", description = "维修作业---钢轨波磨检查")
public class WorkBatchDetailCorrugationInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableField("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("分析批id")
    @TableField("analysis_batch_id")
    private String analysisBatchId;

    @ApiModelProperty("分析批次号")
    @TableField("analysis_batch_code")
    private String analysisBatchCode;

    @ApiModelProperty("设备检查记录主表id（t_ek_records_master_check）")
    @TableField("ek_id")
    private String ekId;

    @ApiModelProperty("检查批次号（t_ek_records_master_check）")
    @TableField("ek_code")
    private String ekCode;

    @ApiModelProperty("单元表id（t_dsa_analysis_line_batch_unit_device）")
    @TableField("device_id")
    private String deviceId;

    @ApiModelProperty("维修作业主表id")
    @TableField("work_id")
    private String workId;

    @ApiModelProperty("维修作业单元表id")
    @TableField("work_detail_id")
    private String workDetailId;

    @ApiModelProperty("检查设备id(设备资产四种表的主键)")
    @TableField("device_project_id")
    private String deviceProjectId;

    @ApiModelProperty("检查设备单元编码(设备资产四种表的unit_code)")
    @TableField("device_project_code")
    private String deviceProjectCode;

    @ApiModelProperty("检查设备类型（1-钢轨,2-曲线,3-竖曲线,4-道岔）")
    @TableField("device_project_type")
    private Integer deviceProjectType;

    @ApiModelProperty("曲线半径")
    @TableField("curve_radius")
    private BigDecimal curveRadius;

    @ApiModelProperty("曲线超高")
    @TableField("super_high")
    private BigDecimal superHigh;

    @ApiModelProperty("曲线长度")
    @TableField("curve_len")
    private BigDecimal curveLen;

    @ApiModelProperty("检查项目-波段-谷深(10-30)")
    @TableField("check_band_one")
    private BigDecimal checkBandOne;

    @ApiModelProperty("检查项目-波段-谷深(30-100)")
    @TableField("check_band_two")
    private BigDecimal checkBandTwo;

    @ApiModelProperty("检查项目-波段-谷深(100-300)")
    @TableField("check_band_three")
    private BigDecimal checkBandThree;

    @ApiModelProperty("检查项目-波段-谷深(300-1000)")
    @TableField("check_band_four")
    private BigDecimal checkBandFour;

    @ApiModelProperty("超限记录")
    @TableField("overrun_info")
    private String overrunInfo;

    @ApiModelProperty("整改备注")
    @TableField("reform_remark")
    private String reformRemark;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    @TableField("del_flag")
    private String delFlag;


}
