package org.jeecg.modules.maintenanceWork.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.jeecg.modules.homePage.vo.ToDoDetailVO;
import org.jeecg.modules.maintenanceWork.dto.UnitDeviceDTO;
import org.jeecg.modules.maintenanceWork.dto.WorkBatchDTO;
import org.jeecg.modules.maintenanceWork.entity.WorkBatch;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.jeecg.modules.maintenanceWork.vo.*;
import org.jeecg.modules.unitDevice.dto.CaseReportCheckDataDTO;
import org.jeecg.modules.unitDevice.dto.CaseReportWorkBatchDTO;
import org.jeecg.modules.unitDevice.vo.CaseReportCheckDataVO;
import org.jeecg.modules.unitDevice.vo.CaseReportWorkBatchVO;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 维修作业管理-作业计划批次管理表 Mapper 接口
 * </p>
 *
 * @author hkl
 * @since 2023-08-09
 */
public interface WorkBatchMapper extends BaseMapper<WorkBatch> {

    Page<WorkBatchVO> listRecord(Page<WorkBatchVO> pageData, WorkBatchDTO dto);

    Page<Map<String, Object>> getUnitDevicePage(Page<Map<String, Object>> pageData, UnitDeviceDTO dto);

    Page<CaseReportWorkBatchVO> caseReportWorkBatch(Page<CaseReportWorkBatchVO> pageData, CaseReportWorkBatchDTO dto);

    List<ToDoDetailVO> getTodoList(String currentUserId);

    List<WorkBatchUserVO> listUser(String query);
    /**
     * 整改道岔
     * @param workId 维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    List<WorkBatchDetailTurnoutInfoVO> getWorkBatchDetailTurnoutInfoList(@Param("workId") String workId, @Param("workInfoId")String workInfoId);

    /**
     * 整改钢轨伤损
     * @param workId 维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    List<WorkBatchDetailRailWearInfoVO> getWorkBatchDetailRailWearInfoList(@Param("workId") String workId, @Param("workInfoId")String workInfoId);
    /**
     * 整改曲线磨耗
     * @param workId 维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    List<WorkBatchDetailCurveWearInfoVO> getWorkBatchDetailCurveWearInfoList(@Param("workId") String workId, @Param("workInfoId")String workInfoId);
    /**
     * 整改钢轨波磨
     * @param workId 维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    List<WorkBatchDetailCorrugationInfoVO> getWorkBatchDetailCorrugationInfoList(@Param("workId") String workId, @Param("workInfoId")String workInfoId);
    /**
     * 整改道床
     * @param workId 维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    List<WorkBatchDetailTrackBedInfoVO> getWorkBatchDetailTrackBedInfoList(@Param("workId") String workId, @Param("workInfoId")String workInfoId);

    /**
     * 整改线路巡查
     * @param workId 维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    List<WorkBatchDetailPatrolInfoVO> getWorkBatchDetailPatrolInfoList(@Param("workId") String workId, @Param("workInfoId")String workInfoId);

    /**
     * 整改协助线路巡查
     * @param workId 维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    List<WorkBatchDetailPatrolAssistInfoVO> getWorkBatchDetailPatrolAssistInfoList(@Param("workId") String workId, @Param("workInfoId")String workInfoId);

}
