package org.jeecg.modules.maintenanceWork.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.modules.diseaseAnalysis.dto.AnalysisLineBatchInfoDTO;
import org.jeecg.modules.diseaseAnalysis.entity.AnalysisLineBatchUnitDevice;
import org.jeecg.modules.diseaseAnalysis.service.IAnalysisLineBatchService;
import org.jeecg.modules.diseaseAnalysis.service.IAnalysisLineBatchUnitDeviceService;
import org.jeecg.modules.diseaseAnalysis.vo.*;
import org.jeecg.modules.dynamicStaticAnalysis.dto.AnalysisBatchUnitDeviceDTO;
import org.jeecg.modules.dynamicStaticAnalysis.mapper.AnalysisBatchUnitDeviceMapper;
import org.jeecg.modules.dynamicStaticAnalysis.mapper.AnalysisBatchUnitDeviceTransfiniteMapper;
import org.jeecg.modules.dynamicStaticAnalysis.vo.AnalysisBatchUnitDeviceTransfiniteVO;
import org.jeecg.modules.dynamicStaticAnalysis.vo.AnalysisBatchUnitDeviceVO;
import org.jeecg.modules.homePage.vo.ToDoDetailVO;
import org.jeecg.modules.maintenanceWork.dto.*;
import org.jeecg.modules.maintenanceWork.entity.*;
import org.jeecg.modules.maintenanceWork.mapper.*;
import org.jeecg.modules.maintenanceWork.service.IWorkBatchService;
import org.jeecg.modules.maintenanceWork.vo.*;
import org.jeecg.modules.unitDevice.dto.CaseReportWorkBatchDTO;
import org.jeecg.modules.unitDevice.vo.CaseReportWorkBatchVO;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 维修作业管理-作业计划批次管理表 服务实现类
 * </p>
 *
 * @author hkl
 * @since 2023-08-09
 */
@Service
public class WorkBatchServiceImpl extends ServiceImpl<WorkBatchMapper, WorkBatch> implements IWorkBatchService {
    @Resource
    private WorkBatchDetailMapper workBatchDetailMapper;

    @Resource
    private WorkBatchDetailModifyMapper workBatchDetailModifyMapper;

    @Resource
    private AnalysisBatchUnitDeviceMapper analysisBatchUnitDeviceMapper;

    @Resource
    private AnalysisBatchUnitDeviceTransfiniteMapper transfiniteMapper;

    @Resource
    private IAnalysisLineBatchUnitDeviceService analysisLineBatchUnitDeviceService;

    @Resource
    private IAnalysisLineBatchService analysisLineBatchService;

    @Resource
    private WorkBatchDetailCorrugationInfoMapper corrugationInfoMapper;

    @Resource
    private WorkBatchDetailCurveWearInfoMapper curveWearInfoMapper;

    @Resource
    private WorkBatchDetailPatrolAssistInfoMapper patrolAssistInfoMapper;

    @Resource
    private WorkBatchDetailPatrolInfoMapper patrolInfoMapper;

    @Resource
    private WorkBatchDetailRailWearInfoMapper railWearInfoMapper;

    @Resource
    private WorkBatchDetailTrackBedInfoMapper trackBedInfoMapper;

    @Resource
    private WorkBatchDetailTurnoutInfoMapper turnoutInfoMapper;


    @Override
    public Page<WorkBatchVO> listRecord(Page<WorkBatchVO> pageData, WorkBatchDTO dto) {
        Page<WorkBatchVO> page = this.baseMapper.listRecord(pageData, dto);

        // 作业批次明细,一次性讲当前列表的作业批次相关的详情查询出来通过筛选在重新组装数据
        if (ObjectUtil.isNotEmpty(page.getRecords())) {
            List<String> workBatchIds = page.getRecords().stream().map(WorkBatchVO::getId).collect(Collectors.toList());
            List<WorkBatchDetailVO> workBatchDetailAllList = workBatchDetailMapper.queryListByWorkBatchIds(workBatchIds);
            Map<String, List<WorkBatchDetailVO>> workBatchDetailMap = workBatchDetailAllList.stream().collect(Collectors.groupingBy(WorkBatchDetailVO::getWorkBatchId, LinkedHashMap::new, Collectors.toList()));

            page.getRecords().forEach(record -> {
                List<WorkBatchDetailVO> workBatchDetailList = workBatchDetailMap.get(record.getId());
                workBatchDetailList = workBatchDetailList == null ? new ArrayList<>() : workBatchDetailList;
                record.setDetailList(workBatchDetailList);
            });


            //作业批次明细-超限列表
            List<String> analysisBatchUnitDeviceIds = workBatchDetailAllList.stream().filter(obj -> obj.getAnalysisBatchUnitDeviceId() != null).map(WorkBatchDetailVO::getAnalysisBatchUnitDeviceId).collect(Collectors.toList());
            if (ObjectUtil.isNotEmpty(analysisBatchUnitDeviceIds)) {
                List<AnalysisBatchUnitDeviceTransfiniteVO> transfiniteListAll = transfiniteMapper.getTransfiniteListByIds(analysisBatchUnitDeviceIds);
                Map<String, List<AnalysisBatchUnitDeviceTransfiniteVO>> map = transfiniteListAll.stream().collect(Collectors.groupingBy(AnalysisBatchUnitDeviceTransfiniteVO::getAnalysisBatchUnitDeviceId, LinkedHashMap::new, Collectors.toList()));

                workBatchDetailAllList.forEach(record -> {
                    List<AnalysisBatchUnitDeviceTransfiniteVO> transfiniteList = map.get(record.getAnalysisBatchUnitDeviceId());
                    transfiniteList = transfiniteList == null ? new ArrayList<>() : transfiniteList;
                    record.setTransfiniteList(transfiniteList);
                });
            }
        }
        return page;
    }

    /**
     * 动静态超限数据查询
     *
     * @param analysisBatchUnitDeviceId
     * @return
     */
    @Override
    public List<AnalysisBatchUnitDeviceTransfiniteVO> getTransfiniteList(String analysisBatchUnitDeviceId) {
        List<String> ids = new ArrayList<>();
        ids.add(analysisBatchUnitDeviceId);
        List<AnalysisBatchUnitDeviceTransfiniteVO> transfiniteListAll = transfiniteMapper.getTransfiniteListByIds(ids);
        return transfiniteListAll;
    }

    /**
     * 道岔
     *
     * @param analysisBatchId           分析批次id
     * @param analysisBatchUnitDeviceId 分析单元id
     * @return
     */
    @Override
    public List<AnalysisLineBatchUnitDeviceTurnoutInfoVO> getAnalysisLineBatchUnitEkInfoList(String analysisBatchId, String analysisBatchUnitDeviceId) {
        List<AnalysisLineBatchUnitDeviceTurnoutInfoVO> analysisLineBatchUnitEkInfoList = analysisLineBatchService.getAnalysisLineBatchUnitEkInfoList(analysisBatchId, "", analysisBatchUnitDeviceId);
        return analysisLineBatchUnitEkInfoList;
    }

    /**
     * 钢轨伤损
     *
     * @param analysisBatchId           分析批次id
     * @param analysisBatchUnitDeviceId 分析单元id
     * @return
     */
    @Override
    public List<AnalysisLineBatchUnitDeviceRailWearInfoVO> getAnalysisLineBatchUnitDeviceRailWearInfoList(String analysisBatchId, String analysisBatchUnitDeviceId) {
        List<AnalysisLineBatchUnitDeviceRailWearInfoVO> analysisLineBatchUnitDeviceRailWearInfoVOList = analysisLineBatchService.getAnalysisLineBatchUnitDeviceRailWearInfoList(analysisBatchId, "", analysisBatchUnitDeviceId);
        return analysisLineBatchUnitDeviceRailWearInfoVOList;
    }

    /**
     * 曲线磨耗检查
     *
     * @param analysisBatchId           分析批次id
     * @param analysisBatchUnitDeviceId 分析单元id
     * @return
     */
    @Override
    public List<AnalysisLineBatchUnitDeviceCurveWearInfoVO> getAnalysisLineBatchUnitDeviceCurveWearInfoList(String analysisBatchId, String analysisBatchUnitDeviceId) {
        List<AnalysisLineBatchUnitDeviceCurveWearInfoVO> analysisLineBatchUnitDeviceCurveWearInfoList = analysisLineBatchService.getAnalysisLineBatchUnitDeviceCurveWearInfoList(analysisBatchId, "", analysisBatchUnitDeviceId);
        return analysisLineBatchUnitDeviceCurveWearInfoList;
    }

    /**
     * 钢轨波磨检查
     *
     * @param analysisBatchId           分析批次id
     * @param analysisBatchUnitDeviceId 分析单元id
     * @return
     */
    @Override
    public List<AnalysisLineBatchUnitDeviceCorrugationInfoVO> getAnalysisLineBatchUnitDeviceCorrugationInfoList(String analysisBatchId, String analysisBatchUnitDeviceId) {
        List<AnalysisLineBatchUnitDeviceCorrugationInfoVO> analysisLineBatchUnitDeviceCorrugationInfoList = analysisLineBatchService.getAnalysisLineBatchUnitDeviceCorrugationInfoList(analysisBatchId, "", analysisBatchUnitDeviceId);
        return analysisLineBatchUnitDeviceCorrugationInfoList;
    }

    /**
     * 道床检查
     *
     * @param analysisBatchId           分析批次id
     * @param analysisBatchUnitDeviceId 分析单元id
     * @return
     */
    @Override
    public List<AnalysisLineBatchUnitDeviceTrackBedInfoVO> getAnalysisLineBatchUnitDeviceTrackBedInfoList(String analysisBatchId, String analysisBatchUnitDeviceId) {
        List<AnalysisLineBatchUnitDeviceTrackBedInfoVO> analysisLineBatchUnitDeviceTrackBedInfoVOList = analysisLineBatchService.getAnalysisLineBatchUnitDeviceTrackBedInfoList(analysisBatchId, "", analysisBatchUnitDeviceId);
        return analysisLineBatchUnitDeviceTrackBedInfoVOList;
    }

    /**
     * 线路巡查
     *
     * @param analysisBatchId           分析批次id
     * @param analysisBatchUnitDeviceId 分析单元id
     * @return
     */
    @Override
    public List<AnalysisLineBatchUnitDevicePatrolInfoVO> getAnalysisLineBatchUnitDevicePatrolInfoList(String analysisBatchId, String analysisBatchUnitDeviceId) {
        List<AnalysisLineBatchUnitDevicePatrolInfoVO> patrolInfoList = analysisLineBatchService.getAnalysisLineBatchUnitDevicePatrolInfoList(analysisBatchId, "", analysisBatchUnitDeviceId);
        return patrolInfoList;
    }

    /**
     * 协助线路巡查
     *
     * @param analysisBatchId           分析批次id
     * @param analysisBatchUnitDeviceId 分析单元id
     * @return
     */
    @Override
    public List<AnalysisLineBatchUnitDevicePatrolAssistInfoVO> getAnalysisLineBatchUnitDevicePatrolAssistInfoList(String analysisBatchId, String analysisBatchUnitDeviceId) {
        List<AnalysisLineBatchUnitDevicePatrolAssistInfoVO> patrolAssistInfoList = analysisLineBatchService.getAnalysisLineBatchUnitDevicePatrolAssistInfoList(analysisBatchId, "", analysisBatchUnitDeviceId);
        return patrolAssistInfoList;
    }

    @Override
    @Transactional
    public void saveRecord(WorkBatchSaveOrUpdateDTO dto) {
        // 保存主信息
        WorkBatch workBatch = BeanUtil.copyProperties(dto, WorkBatch.class);
        if (ObjectUtil.isEmpty(dto.getId())) {
            workBatch.setId(UUIDGenerator.generate());
            workBatch.setWorkStatus(0);
        }

        this.saveOrUpdate(workBatch);
        // 保证明细信息
        // 先删除
        LambdaQueryWrapper<WorkBatchDetail> delWrapper = Wrappers.lambdaQuery();
        delWrapper.eq(WorkBatchDetail::getWorkBatchId, dto.getId());
        workBatchDetailMapper.delete(delWrapper);
        List<WorkBatchSaveOrUpdateDetailDTO> transfiniteList = dto.getDetailList();
        //获取当前登录人信息
        LoginUser user = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        String username = user.getUsername();
        for (WorkBatchSaveOrUpdateDetailDTO detailDTO : transfiniteList) {
            WorkBatchDetail workBatchDetail = new WorkBatchDetail();
            workBatchDetail.setId(UUIDGenerator.generate());
            workBatchDetail.setWorkBatchId(workBatch.getId());
            workBatchDetail.setWorkBatchCode(workBatch.getWorkBatchCode());
            if (dto.getWorkType() == 2) {
                //分析批次方式代表道床、线路巡查病害分析
                workBatchDetail.setAnalysisBatchId(detailDTO.getAnalysisBatchId());
                workBatchDetail.setAnalysisBatchCode(detailDTO.getAnalysisBatchCode());
                workBatchDetail.setCheckBy(detailDTO.getCheckBy());
                workBatchDetail.setCheckTime(detailDTO.getCheckTime());
                workBatchDetail.setEkId(detailDTO.getEkId());
                workBatchDetail.setEkCode(detailDTO.getEkCode());
                AnalysisLineBatchUnitDevice model = analysisLineBatchUnitDeviceService.lambdaQuery()
                        .eq(AnalysisLineBatchUnitDevice::getAnalysisBatchId, detailDTO.getAnalysisBatchId())
                        .one();
                if (model != null) {
                    workBatchDetail.setAnalysisBatchUnitDeviceId(model.getId());
                } else {
                    throw JeecgBootException.error("数据错误！");
                }

            } else {
                workBatchDetail.setUnitId(detailDTO.getUnitId());
                workBatchDetail.setUnitCode(detailDTO.getUnitCode());
                workBatchDetail.setUnitType(detailDTO.getType());
                workBatchDetail.setUnitTypeName(detailDTO.getUnitTypeName());
                workBatchDetail.setUnitDeviceCode(detailDTO.getUnitDeviceCode());
                workBatchDetail.setUnitCenterMileage(detailDTO.getUnitCenterMileage());
                workBatchDetail.setUnitScore(detailDTO.getUnitScore());
                workBatchDetail.setUnitScoreLevel(detailDTO.getUnitScoreLevel());
            }
            workBatchDetail.setUnitStartMileage(detailDTO.getUnitStartMileage());
            workBatchDetail.setUnitEndMileage(detailDTO.getUnitEndMileage());
            workBatchDetail.setRemark(detailDTO.getRemark());
            workBatchDetail.setUpdateTime(new Date());
            workBatchDetail.setCreateTime(new Date());
            workBatchDetail.setCreateBy(username);
            workBatchDetail.setUpdateBy(username);
            workBatchDetail.setWorkStatus(0);
            workBatchDetailMapper.insert(workBatchDetail);
        }
    }

    @Override
    @Transactional
    public void deleteRecord(String workBatchId) {
        //查询作业主表
        WorkBatch workBatch = this.baseMapper.selectById(workBatchId);
        if(workBatch == null){
            throw JeecgBootException.error("删除失败，没找到作业数据！");
        }
        if(workBatch.getWorkStatus() == 9){
            throw JeecgBootException.error("当前作业已完成无法删除！");
        }
        //删除整改详情表
        LambdaQueryWrapper<WorkBatchDetailModify> delModifyWrapper = Wrappers.lambdaQuery();
        delModifyWrapper.eq(WorkBatchDetailModify::getWorkBatchId, workBatchId);
        workBatchDetailModifyMapper.delete(delModifyWrapper);

        LambdaQueryWrapper<WorkBatchDetailCorrugationInfo> delCorrugationInfoWrapper = Wrappers.lambdaQuery();
        delCorrugationInfoWrapper.eq(WorkBatchDetailCorrugationInfo::getWorkId, workBatchId);
        corrugationInfoMapper.delete(delCorrugationInfoWrapper);

        LambdaQueryWrapper<WorkBatchDetailCurveWearInfo> delCurveWearInfoWrapper = Wrappers.lambdaQuery();
        delCurveWearInfoWrapper.eq(WorkBatchDetailCurveWearInfo::getWorkId, workBatchId);
        curveWearInfoMapper.delete(delCurveWearInfoWrapper);

        LambdaQueryWrapper<WorkBatchDetailPatrolAssistInfo> delPatrolAssistInfoWrapper = Wrappers.lambdaQuery();
        delPatrolAssistInfoWrapper.eq(WorkBatchDetailPatrolAssistInfo::getWorkId, workBatchId);
        patrolAssistInfoMapper.delete(delPatrolAssistInfoWrapper);

        LambdaQueryWrapper<WorkBatchDetailPatrolInfo> delPatrolInfoWrapper = Wrappers.lambdaQuery();
        delPatrolInfoWrapper.eq(WorkBatchDetailPatrolInfo::getWorkId, workBatchId);
        patrolInfoMapper.delete(delPatrolInfoWrapper);

        LambdaQueryWrapper<WorkBatchDetailRailWearInfo> delRailWearInfoWrapper = Wrappers.lambdaQuery();
        delRailWearInfoWrapper.eq(WorkBatchDetailRailWearInfo::getWorkId, workBatchId);
        railWearInfoMapper.delete(delRailWearInfoWrapper);

        LambdaQueryWrapper<WorkBatchDetailTrackBedInfo> delTrackBedInfoWrapper = Wrappers.lambdaQuery();
        delTrackBedInfoWrapper.eq(WorkBatchDetailTrackBedInfo::getWorkId, workBatchId);
        trackBedInfoMapper.delete(delTrackBedInfoWrapper);

        LambdaQueryWrapper<WorkBatchDetailTurnoutInfo> delTurnoutInfoWrapper = Wrappers.lambdaQuery();
        delTurnoutInfoWrapper.eq(WorkBatchDetailTurnoutInfo::getWorkId, workBatchId);
        turnoutInfoMapper.delete(delTurnoutInfoWrapper);

        //删除维修单元表
        LambdaQueryWrapper<WorkBatchDetail> delWrapper = Wrappers.lambdaQuery();
        delWrapper.eq(WorkBatchDetail::getWorkBatchId, workBatchId);
        workBatchDetailMapper.delete(delWrapper);

        //删除维修主表
        this.removeById(workBatchId);
    }

    @Override
    @Transactional
    public void transfiniteSaveRecord(WorkBatchTransfiniteSaveDTO dto) {
        WorkBatch workBatch = BeanUtil.copyProperties(dto, WorkBatch.class);
        workBatch.setId(UUIDGenerator.generate());
        workBatch.setWorkStatus(0);
        workBatch.setSource(2); // 超限页面
        workBatch.setDelFlag("0");
        this.save(workBatch);
        // 保存明细
        //获取当前登录人信息
        LoginUser user = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        String username = user.getUsername();
        List<DispatchDTO> transfiniteList = dto.getDetailList();
        List<WorkBatchDetail> workBatchDetailList = new ArrayList<>();
        List<AnalysisLineBatchUnitDevice> analysisLineBatchUnitDeviceList = new ArrayList<>();
        for (DispatchDTO transfiniteDTO : transfiniteList) {
            WorkBatchDetail workBatchDetail = new WorkBatchDetail();
            workBatchDetail.setId(UUIDGenerator.generate());
            workBatchDetail.setWorkBatchId(workBatch.getId());
            workBatchDetail.setWorkBatchCode(workBatch.getWorkBatchCode());
            workBatchDetail.setAnalysisBatchId(transfiniteDTO.getAnalysisBatchId());
            workBatchDetail.setAnalysisBatchCode(transfiniteDTO.getAnalysisBatchCode());
            workBatchDetail.setAnalysisBatchUnitDeviceId(transfiniteDTO.getId());
            workBatchDetail.setCheckBy(transfiniteDTO.getCheckBy());
            workBatchDetail.setCheckTime(transfiniteDTO.getCheckTime());
            if (dto.getAnalysisType() != 0) {
                workBatchDetail.setEkId(transfiniteDTO.getEkId());
                workBatchDetail.setEkCode(transfiniteDTO.getEkCode());
            }
            if (dto.getAnalysisType() != 5 && dto.getAnalysisType() != 6) {
                //非道床和线路巡查才存单元设备信息
                workBatchDetail.setUnitId(transfiniteDTO.getUnitId());
                workBatchDetail.setUnitCode(transfiniteDTO.getUnitCode());
                workBatchDetail.setUnitType(transfiniteDTO.getUnitType());
                workBatchDetail.setUnitTypeName(transfiniteDTO.getUnitTypeName());
                workBatchDetail.setUnitDeviceCode(transfiniteDTO.getUnitDeviceCode());
                workBatchDetail.setUnitCenterMileage(transfiniteDTO.getUnitCenterMileage());
            }
            workBatchDetail.setUnitStartMileage(transfiniteDTO.getUnitStartingMileage());
            workBatchDetail.setUnitEndMileage(transfiniteDTO.getUnitEndMileage());
            if (dto.getAnalysisType() == 0) {
                //动静态分析需要存得参数
                workBatchDetail.setUnitScoreLevel(Integer.valueOf(transfiniteDTO.getUnitScoreLevel()));
                workBatchDetail.setUnitScore(transfiniteDTO.getUnitScore());
                workBatchDetail.setUnitScoreLevelStr(transfiniteDTO.getUnitScoreLevelStr());
            }
            workBatchDetail.setWorkStatus(0);
            workBatchDetail.setUpdateTime(new Date());
            workBatchDetail.setCreateTime(new Date());
            workBatchDetail.setCreateBy(username);
            workBatchDetail.setUpdateBy(username);

            workBatchDetailList.add(workBatchDetail);
            //其他病害分析
            if (dto.getAnalysisType() != 0) {
                AnalysisLineBatchUnitDevice analysisLineBatchUnitDevice = new AnalysisLineBatchUnitDevice();
                analysisLineBatchUnitDevice.setId(transfiniteDTO.getId());
                analysisLineBatchUnitDevice.setWorkStatus(2);
                analysisLineBatchUnitDeviceList.add(analysisLineBatchUnitDevice);
            }

        }
        workBatchDetailMapper.insertBatch(workBatchDetailList);
        //其他病害分析更新派工状态
        if (dto.getAnalysisType() != 0) {
            if (CollectionUtils.isNotEmpty(analysisLineBatchUnitDeviceList)) {
                analysisLineBatchUnitDeviceService.updateBatchById(analysisLineBatchUnitDeviceList);
            }
        }
    }


    @Override
    public Page<Map<String, Object>> getUnitDevicePage(Page<Map<String, Object>> pageData, UnitDeviceDTO dto) {

        return this.baseMapper.getUnitDevicePage(pageData, dto);

    }

    @Override
    @Transactional
    public void batchSaveRecord(AnalysisBatchSaveDTO dto) {
        // 1.构建工单主信息
        WorkBatch workBatch = BeanUtil.copyProperties(dto, WorkBatch.class);
        workBatch.setId(UUIDGenerator.generate());
        workBatch.setWorkStatus(0); //0-未作业 9-已作业
        workBatch.setSource(2); // 超限页面
        workBatch.setDelFlag("0"); // 超限页面
        //获取当前登录人信息
        LoginUser user = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        String realname = user.getRealname();

        //循环构建保存对象
        List<WorkBatchDetail> workBatchDetailList = new ArrayList<>();
        //更新已派工
        List<AnalysisLineBatchUnitDevice> analysisLineBatchUnitDeviceList = new ArrayList<>();
        if (dto.getAnalysisType() == 0) {
            // 2.1 构建查询对象
            AnalysisBatchUnitDeviceDTO params = new AnalysisBatchUnitDeviceDTO();
            params.setAnalysisBatchId(dto.getAnalysisBatchId());
            params.setIsTransfinite(1); // 1-超限
            params.setWorkStatus(0);// 0-未派工

            // 2.1.1 一键全部派工按:照搜索条件来的
            if (dto.getSaveType() == 1) {
                params.setUnitCode(dto.getForm().getUnitCode());
                params.setUnitDeviceCode(dto.getForm().getUnitDeviceCode());
                params.setGradeJudgeList(dto.getForm().getGradeJudgeList());
                params.setUnitTypeList(dto.getForm().getUnitTypeList());
                params.setUnitStartingMileage(dto.getForm().getUnitStartingMileage());
                params.setUnitEndMileage(dto.getForm().getUnitEndMileage());
            }
            // 2.1.2 一键失格派工:只要单元质量评价为失格的
            if (dto.getSaveType() == 2) {
                List<String> gradeJudgeList = new ArrayList<>();
                gradeJudgeList.add("3");
                params.setGradeJudgeList(gradeJudgeList);
            }

            // 2.2 查询
            List<AnalysisBatchUnitDeviceVO> transfiniteList = analysisBatchUnitDeviceMapper.listRecord(params);
            if (ObjectUtil.isEmpty(transfiniteList)) {
                throw JeecgBootException.error("创建失败,没有对应的超限数据");
            }
            for (AnalysisBatchUnitDeviceVO transfinite : transfiniteList) {
                WorkBatchDetail workBatchDetail = new WorkBatchDetail();
                workBatchDetail.setId(UUIDGenerator.generate());
                workBatchDetail.setWorkBatchId(workBatch.getId());
                workBatchDetail.setWorkBatchCode(workBatch.getWorkBatchCode());
                workBatchDetail.setAnalysisBatchUnitDeviceId(transfinite.getId());
                workBatchDetail.setAnalysisBatchId(transfinite.getAnalysisBatchId());
                workBatchDetail.setAnalysisBatchCode(transfinite.getAnalysisBatchCode());
                workBatchDetail.setUnitId(transfinite.getUnitId());
                workBatchDetail.setUnitCode(transfinite.getUnitCode());
                workBatchDetail.setUnitType(transfinite.getUnitType());
                workBatchDetail.setUnitTypeName(transfinite.getUnitTypeName());
                workBatchDetail.setUnitDeviceCode(transfinite.getUnitDeviceCode());
                workBatchDetail.setUnitStartMileage(transfinite.getUnitStartingMileage());
                workBatchDetail.setUnitEndMileage(transfinite.getUnitEndMileage());
                workBatchDetail.setUnitCenterMileage(transfinite.getUnitCenterMileage());
                workBatchDetail.setUnitScore(Convert.toBigDecimal(transfinite.getUnitScore()));
                workBatchDetail.setUnitScoreLevel(transfinite.getUnitScoreLevel());
                workBatchDetail.setUnitScoreLevelStr(transfinite.getUnitScoreLevelStr());
                workBatchDetail.setUpdateTime(new Date());
                workBatchDetail.setCreateTime(new Date());
                workBatchDetail.setCreateBy(realname);
                workBatchDetail.setUpdateBy(realname);
                workBatchDetail.setWorkStatus(0);
                workBatchDetailList.add(workBatchDetail);
            }
        } else {
            AnalysisLineBatchInfoDTO params = new AnalysisLineBatchInfoDTO();
            params.setAnalysisBatchId(dto.getAnalysisBatchId());
            params.setWorkStatus(1);// 0-未派工
            Page<AnalysisLineBatchUnitDeviceVO> pageData = new Page<>(1, 99999);
            Page<AnalysisLineBatchUnitDeviceVO> pageList = analysisLineBatchService.getInfoPageList(pageData, params);
            List<AnalysisLineBatchUnitDeviceVO> records = pageList.getRecords();
            // 2.3 循环构建保存对象
            if (CollectionUtils.isEmpty(records)) {
                throw JeecgBootException.error("创建失败,没有对应的线路超限数据");
            }
            for (AnalysisLineBatchUnitDeviceVO transfinite : records) {
                WorkBatchDetail workBatchDetail = new WorkBatchDetail();
                workBatchDetail.setId(UUIDGenerator.generate());
                workBatchDetail.setWorkBatchId(workBatch.getId());
                workBatchDetail.setWorkBatchCode(workBatch.getWorkBatchCode());
                workBatchDetail.setAnalysisBatchUnitDeviceId(transfinite.getId());
                workBatchDetail.setAnalysisBatchId(transfinite.getAnalysisBatchId());
                workBatchDetail.setAnalysisBatchCode(transfinite.getAnalysisBatchCode());
                workBatchDetail.setCheckBy(dto.getCheckBy());
                workBatchDetail.setCheckTime(dto.getCheckTime());
                workBatchDetail.setEkId(transfinite.getEkId());
                workBatchDetail.setEkCode(transfinite.getEkCode());
                if (dto.getAnalysisType() != 5 && dto.getAnalysisType() != 6) {
                    //非动静态分析且非道床和线路巡查分析才保存这些参数
                    workBatchDetail.setUnitId(transfinite.getUnitId());
                    workBatchDetail.setUnitCode(transfinite.getUnitCode());
                    workBatchDetail.setUnitType(transfinite.getUnitType());
                    workBatchDetail.setUnitTypeName(transfinite.getUnitTypeName());
                    workBatchDetail.setUnitDeviceCode(transfinite.getUnitDeviceCode());
                    workBatchDetail.setUnitCenterMileage(transfinite.getUnitCenterMileage());
                }
                workBatchDetail.setUnitStartMileage(transfinite.getUnitStartMileage());
                workBatchDetail.setUnitEndMileage(transfinite.getUnitEndMileage());
                workBatchDetail.setUpdateTime(new Date());
                workBatchDetail.setCreateTime(new Date());
                workBatchDetail.setCreateBy(realname);
                workBatchDetail.setUpdateBy(realname);
                workBatchDetail.setWorkStatus(0);
                workBatchDetailList.add(workBatchDetail);
                AnalysisLineBatchUnitDevice analysisLineBatchUnitDevice = new AnalysisLineBatchUnitDevice();
                analysisLineBatchUnitDevice.setId(transfinite.getId());
                analysisLineBatchUnitDevice.setWorkStatus(2);
                analysisLineBatchUnitDeviceList.add(analysisLineBatchUnitDevice);
            }
        }
        // 3. 执行数据库保存
        this.save(workBatch);
        workBatchDetailMapper.insertBatch(workBatchDetailList);
        //其他病害分析更新派工状态
        if (dto.getAnalysisType() != 0) {
            if (CollectionUtils.isNotEmpty(analysisLineBatchUnitDeviceList)) {
                analysisLineBatchUnitDeviceService.updateBatchById(analysisLineBatchUnitDeviceList);
            }
        }
    }

    @Override
    public Page<CaseReportWorkBatchVO> caseReportWorkBatch(Page<CaseReportWorkBatchVO> pageData, CaseReportWorkBatchDTO dto) {
        return this.baseMapper.caseReportWorkBatch(pageData, dto);
    }

    @Override
    public List<ToDoDetailVO> getTodoList(String currentUserId) {
        return this.baseMapper.getTodoList(currentUserId);
    }

    @Override
    public List<WorkBatchUserVO> listUser(String query) {
        return this.baseMapper.listUser(query);
    }

    /**
     * 整改道岔
     *
     * @param workId     维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    @Override
    public List<WorkBatchDetailTurnoutInfoVO> getWorkBatchDetailTurnoutInfoList(String workId, String workInfoId) {
        List<WorkBatchDetailTurnoutInfoVO> list = this.baseMapper.getWorkBatchDetailTurnoutInfoList(workId, workInfoId);
        return list;
    }

    /**
     * 整改钢轨伤损
     *
     * @param workId     维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    @Override
    public List<WorkBatchDetailRailWearInfoVO> getWorkBatchDetailRailWearInfoList(String workId, String workInfoId) {
        List<WorkBatchDetailRailWearInfoVO> list = this.baseMapper.getWorkBatchDetailRailWearInfoList(workId, workInfoId);
        return list;
    }

    /**
     * 整改曲线磨耗
     *
     * @param workId     维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    @Override
    public List<WorkBatchDetailCurveWearInfoVO> getWorkBatchDetailCurveWearInfoList(String workId, String workInfoId) {
        List<WorkBatchDetailCurveWearInfoVO> list = this.baseMapper.getWorkBatchDetailCurveWearInfoList(workId, workInfoId);
        return list;
    }

    /**
     * 整改钢轨波磨
     *
     * @param workId     维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    @Override
    public List<WorkBatchDetailCorrugationInfoVO> getWorkBatchDetailCorrugationInfoList(String workId, String workInfoId) {
        List<WorkBatchDetailCorrugationInfoVO> list = this.baseMapper.getWorkBatchDetailCorrugationInfoList(workId, workInfoId);
        return list;
    }

    /**
     * 整改道床
     *
     * @param workId     维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    @Override
    public List<WorkBatchDetailTrackBedInfoVO> getWorkBatchDetailTrackBedInfoList(String workId, String workInfoId) {
        List<WorkBatchDetailTrackBedInfoVO> list = this.baseMapper.getWorkBatchDetailTrackBedInfoList(workId, workInfoId);
        return list;
    }

    /**
     * 整改线路巡查
     *
     * @param workId     维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    @Override
    public List<WorkBatchDetailPatrolInfoVO> getWorkBatchDetailPatrolInfoList(String workId, String workInfoId) {
        List<WorkBatchDetailPatrolInfoVO> list = this.baseMapper.getWorkBatchDetailPatrolInfoList(workId, workInfoId);
        return list;
    }

    /**
     * 整改协助线路巡查
     *
     * @param workId     维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    @Override
    public List<WorkBatchDetailPatrolAssistInfoVO> getWorkBatchDetailPatrolAssistInfoList(String workId, String workInfoId) {
        List<WorkBatchDetailPatrolAssistInfoVO> list = this.baseMapper.getWorkBatchDetailPatrolAssistInfoList(workId, workInfoId);
        return list;
    }
}
