package org.jeecg.modules.maintenanceWork.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.jeecg.modules.dynamicStaticAnalysis.vo.AnalysisBatchUnitDeviceTransfiniteVO;

/**
 * <p>
 * 维修作业管理-作业计划批次管理明细表
 * </p>
 *
 * @author hkl
 * @since 2023-08-09
 */
@Data
@ApiModel(value = "WorkBatchDetailVO对象", description = "维修作业管理-作业计划批次管理明细表")
public class WorkBatchDetailVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("分析批次id")
    @TableField("analysis_batch_id")
    private String analysisBatchId;

    @ApiModelProperty("分析批次code")
    @TableField("analysis_batch_code")
    private String analysisBatchCode;

    @ApiModelProperty("工作批次code")
    private String workBatchCode;

    @ApiModelProperty("工作批次id")
    private String workBatchId;

    @ApiModelProperty("检查批次id")
    private String ekId;

    @ApiModelProperty("检查批次code")
    private String ekCode;

    @ApiModelProperty("检查日期")
    private Date checkTime;

    @ApiModelProperty("检查人")
    private String checkBy;

    @ApiModelProperty("单元设备id")
    private String unitId;

    @ApiModelProperty("单元设备code")
    private String unitCode;

    @ApiModelProperty("设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔")
    private Integer unitType;

    @ApiModelProperty("设备单元类型名称")
    private String unitTypeName;

    @ApiModelProperty("设备编号")
    private String unitDeviceCode;

    @ApiModelProperty("设备单元起始里程")
    private BigDecimal unitStartMileage;

    @ApiModelProperty("分析批次单元设备id")
    private String analysisBatchUnitDeviceId;

    @ApiModelProperty("设备单元中心里程")
    private BigDecimal unitCenterMileage;

    @ApiModelProperty("设备单元结束里程")
    private BigDecimal unitEndMileage;

    @ApiModelProperty("单元得分等级 1-优良 2-合格 3-失格")
    private Integer unitScoreLevel;

    @ApiModelProperty("单元得分")
    private BigDecimal unitScore;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("整改备注")
    private String reformRemark;

    @ApiModelProperty("超限list")
    private List<AnalysisBatchUnitDeviceTransfiniteVO> transfiniteList;
}
