package org.jeecg.modules.statisticAnalysis.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.modules.statisticAnalysis.service.StatisticAnalysisService;
import org.jeecg.modules.statisticAnalysis.vo.DynamicGeometryVO;
import org.jeecg.modules.statisticAnalysis.vo.RailWearVO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@RequestMapping("/statisticAnalysis")
@Api(tags = "统计分析")
public class StatisticAnalysisController {

    @Resource
    private StatisticAnalysisService statisticAnalysisService;

    @AutoLog(value = "统计分析-线网动态几何尺寸扣分走势图")
    @ApiOperation(value = "统计分析-线网动态几何尺寸扣分走势图", notes = "统计分析-线网动态几何尺寸扣分走势图")
    @GetMapping(value = "/dynamicGeometry")
    public Result<List<DynamicGeometryVO>> dynamicGeometry(String year) {

        List<DynamicGeometryVO> voList = statisticAnalysisService.dynamicGeometry(year);

        return Result.OK(voList);
    }

    @AutoLog(value = "统计分析-钢轨伤损数量统计")
    @ApiOperation(value = "统计分析-钢轨伤损数量统计", notes = "统计分析-钢轨伤损数量统计")
    @GetMapping(value = "/railWear")
    public Result<List<RailWearVO>> railWear(String startMonth, String endMonth) {

        List<RailWearVO> voList = statisticAnalysisService.railWear(startMonth, endMonth);

        return Result.OK(voList);
    }

}
